<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SerialDataListRequest StructType
 * @subpackage Structs
 */
class SerialDataListRequest extends AbstractStructBase
{
    /**
     * The serialData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SerialDataRequest[]
     */
    public $serialData;
    /**
     * Constructor method for SerialDataListRequest
     * @uses SerialDataListRequest::setSerialData()
     * @param \StructType\SerialDataRequest[] $serialData
     */
    public function __construct(array $serialData = array())
    {
        $this
            ->setSerialData($serialData);
    }
    /**
     * Get serialData value
     * @return \StructType\SerialDataRequest[]|null
     */
    public function getSerialData()
    {
        return $this->serialData;
    }
    /**
     * This method is responsible for validating the values passed to the setSerialData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSerialData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSerialDataForArrayConstraintsFromSetSerialData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serialDataListRequestSerialDataItem) {
            // validation for constraint: itemType
            if (!$serialDataListRequestSerialDataItem instanceof \StructType\SerialDataRequest) {
                $invalidValues[] = is_object($serialDataListRequestSerialDataItem) ? get_class($serialDataListRequestSerialDataItem) : sprintf('%s(%s)', gettype($serialDataListRequestSerialDataItem), var_export($serialDataListRequestSerialDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The serialData property can only contain items of type \StructType\SerialDataRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set serialData value
     * @throws \InvalidArgumentException
     * @param \StructType\SerialDataRequest[] $serialData
     * @return \StructType\SerialDataListRequest
     */
    public function setSerialData(array $serialData = array())
    {
        // validation for constraint: array
        if ('' !== ($serialDataArrayErrorMessage = self::validateSerialDataForArrayConstraintsFromSetSerialData($serialData))) {
            throw new \InvalidArgumentException($serialDataArrayErrorMessage, __LINE__);
        }
        $this->serialData = $serialData;
        return $this;
    }
    /**
     * Add item to serialData value
     * @throws \InvalidArgumentException
     * @param \StructType\SerialDataRequest $item
     * @return \StructType\SerialDataListRequest
     */
    public function addToSerialData(\StructType\SerialDataRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SerialDataRequest) {
            throw new \InvalidArgumentException(sprintf('The serialData property can only contain items of type \StructType\SerialDataRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->serialData[] = $item;
        return $this;
    }
}
