<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemIdentityRequest StructType
 * @subpackage Structs
 */
class OrderItemIdentityRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The orderItemList
     * @var \StructType\OrderItemIdentityDataList
     */
    public $orderItemList;
    /**
     * Constructor method for OrderItemIdentityRequest
     * @uses OrderItemIdentityRequest::setAuth()
     * @uses OrderItemIdentityRequest::setOrderNumber()
     * @uses OrderItemIdentityRequest::setOrderItemList()
     * @param \StructType\Authentication $auth
     * @param string $orderNumber
     * @param \StructType\OrderItemIdentityDataList $orderItemList
     */
    public function __construct(\StructType\Authentication $auth = null, $orderNumber = null, \StructType\OrderItemIdentityDataList $orderItemList = null)
    {
        $this
            ->setAuth($auth)
            ->setOrderNumber($orderNumber)
            ->setOrderItemList($orderItemList);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\OrderItemIdentityRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderItemIdentityRequest
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\OrderItemIdentityDataList|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\OrderItemIdentityDataList $orderItemList
     * @return \StructType\OrderItemIdentityRequest
     */
    public function setOrderItemList(\StructType\OrderItemIdentityDataList $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
}
