<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemIdentityDataList StructType
 * @subpackage Structs
 */
class OrderItemIdentityDataList extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderItemIdentityDataRequest[]
     */
    public $orderItem;
    /**
     * Constructor method for OrderItemIdentityDataList
     * @uses OrderItemIdentityDataList::setOrderItem()
     * @param \StructType\OrderItemIdentityDataRequest[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return \StructType\OrderItemIdentityDataRequest[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemIdentityDataListOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderItemIdentityDataListOrderItemItem instanceof \StructType\OrderItemIdentityDataRequest) {
                $invalidValues[] = is_object($orderItemIdentityDataListOrderItemItem) ? get_class($orderItemIdentityDataListOrderItemItem) : sprintf('%s(%s)', gettype($orderItemIdentityDataListOrderItemItem), var_export($orderItemIdentityDataListOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderItem property can only contain items of type \StructType\OrderItemIdentityDataRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemIdentityDataRequest[] $orderItem
     * @return \StructType\OrderItemIdentityDataList
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemIdentityDataRequest $item
     * @return \StructType\OrderItemIdentityDataList
     */
    public function addToOrderItem(\StructType\OrderItemIdentityDataRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemIdentityDataRequest) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of type \StructType\OrderItemIdentityDataRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
}
