<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemShipmentInfoList StructType
 * @subpackage Structs
 */
class OrderItemShipmentInfoList extends AbstractStructBase
{
    /**
     * The shippingAddress
     * @var \StructType\AddressModel
     */
    public $shippingAddress;
    /**
     * The deliveryPointMessage
     * @var string
     */
    public $deliveryPointMessage;
    /**
     * The orderItemIds
     * @var \StructType\OrderItemIdList
     */
    public $orderItemIds;
    /**
     * Constructor method for OrderItemShipmentInfoList
     * @uses OrderItemShipmentInfoList::setShippingAddress()
     * @uses OrderItemShipmentInfoList::setDeliveryPointMessage()
     * @uses OrderItemShipmentInfoList::setOrderItemIds()
     * @param \StructType\AddressModel $shippingAddress
     * @param string $deliveryPointMessage
     * @param \StructType\OrderItemIdList $orderItemIds
     */
    public function __construct(\StructType\AddressModel $shippingAddress = null, $deliveryPointMessage = null, \StructType\OrderItemIdList $orderItemIds = null)
    {
        $this
            ->setShippingAddress($shippingAddress)
            ->setDeliveryPointMessage($deliveryPointMessage)
            ->setOrderItemIds($orderItemIds);
    }
    /**
     * Get shippingAddress value
     * @return \StructType\AddressModel|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\AddressModel $shippingAddress
     * @return \StructType\OrderItemShipmentInfoList
     */
    public function setShippingAddress(\StructType\AddressModel $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get deliveryPointMessage value
     * @return string|null
     */
    public function getDeliveryPointMessage()
    {
        return $this->deliveryPointMessage;
    }
    /**
     * Set deliveryPointMessage value
     * @param string $deliveryPointMessage
     * @return \StructType\OrderItemShipmentInfoList
     */
    public function setDeliveryPointMessage($deliveryPointMessage = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPointMessage) && !is_string($deliveryPointMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPointMessage, true), gettype($deliveryPointMessage)), __LINE__);
        }
        $this->deliveryPointMessage = $deliveryPointMessage;
        return $this;
    }
    /**
     * Get orderItemIds value
     * @return \StructType\OrderItemIdList|null
     */
    public function getOrderItemIds()
    {
        return $this->orderItemIds;
    }
    /**
     * Set orderItemIds value
     * @param \StructType\OrderItemIdList $orderItemIds
     * @return \StructType\OrderItemShipmentInfoList
     */
    public function setOrderItemIds(\StructType\OrderItemIdList $orderItemIds = null)
    {
        $this->orderItemIds = $orderItemIds;
        return $this;
    }
}
