<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SerialDataRequest StructType
 * @subpackage Structs
 */
class SerialDataRequest extends AbstractStructBase
{
    /**
     * The serialNumber
     * @var string
     */
    public $serialNumber;
    /**
     * The imei1
     * @var string
     */
    public $imei1;
    /**
     * The imei2
     * @var string
     */
    public $imei2;
    /**
     * Constructor method for SerialDataRequest
     * @uses SerialDataRequest::setSerialNumber()
     * @uses SerialDataRequest::setImei1()
     * @uses SerialDataRequest::setImei2()
     * @param string $serialNumber
     * @param string $imei1
     * @param string $imei2
     */
    public function __construct($serialNumber = null, $imei1 = null, $imei2 = null)
    {
        $this
            ->setSerialNumber($serialNumber)
            ->setImei1($imei1)
            ->setImei2($imei2);
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \StructType\SerialDataRequest
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get imei1 value
     * @return string|null
     */
    public function getImei1()
    {
        return $this->imei1;
    }
    /**
     * Set imei1 value
     * @param string $imei1
     * @return \StructType\SerialDataRequest
     */
    public function setImei1($imei1 = null)
    {
        // validation for constraint: string
        if (!is_null($imei1) && !is_string($imei1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imei1, true), gettype($imei1)), __LINE__);
        }
        $this->imei1 = $imei1;
        return $this;
    }
    /**
     * Get imei2 value
     * @return string|null
     */
    public function getImei2()
    {
        return $this->imei2;
    }
    /**
     * Set imei2 value
     * @param string $imei2
     * @return \StructType\SerialDataRequest
     */
    public function setImei2($imei2 = null)
    {
        // validation for constraint: string
        if (!is_null($imei2) && !is_string($imei2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imei2, true), gettype($imei2)), __LINE__);
        }
        $this->imei2 = $imei2;
        return $this;
    }
}
