<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemShipmentDataList StructType
 * @subpackage Structs
 */
class OrderItemShipmentDataList extends AbstractStructBase
{
    /**
     * The orderItemShipmentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderItemShipmentInfoList[]
     */
    public $orderItemShipmentInfo;
    /**
     * Constructor method for OrderItemShipmentDataList
     * @uses OrderItemShipmentDataList::setOrderItemShipmentInfo()
     * @param \StructType\OrderItemShipmentInfoList[] $orderItemShipmentInfo
     */
    public function __construct(array $orderItemShipmentInfo = array())
    {
        $this
            ->setOrderItemShipmentInfo($orderItemShipmentInfo);
    }
    /**
     * Get orderItemShipmentInfo value
     * @return \StructType\OrderItemShipmentInfoList[]|null
     */
    public function getOrderItemShipmentInfo()
    {
        return $this->orderItemShipmentInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemShipmentInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemShipmentInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemShipmentInfoForArrayConstraintsFromSetOrderItemShipmentInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemShipmentDataListOrderItemShipmentInfoItem) {
            // validation for constraint: itemType
            if (!$orderItemShipmentDataListOrderItemShipmentInfoItem instanceof \StructType\OrderItemShipmentInfoList) {
                $invalidValues[] = is_object($orderItemShipmentDataListOrderItemShipmentInfoItem) ? get_class($orderItemShipmentDataListOrderItemShipmentInfoItem) : sprintf('%s(%s)', gettype($orderItemShipmentDataListOrderItemShipmentInfoItem), var_export($orderItemShipmentDataListOrderItemShipmentInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderItemShipmentInfo property can only contain items of type \StructType\OrderItemShipmentInfoList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderItemShipmentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemShipmentInfoList[] $orderItemShipmentInfo
     * @return \StructType\OrderItemShipmentDataList
     */
    public function setOrderItemShipmentInfo(array $orderItemShipmentInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemShipmentInfoArrayErrorMessage = self::validateOrderItemShipmentInfoForArrayConstraintsFromSetOrderItemShipmentInfo($orderItemShipmentInfo))) {
            throw new \InvalidArgumentException($orderItemShipmentInfoArrayErrorMessage, __LINE__);
        }
        $this->orderItemShipmentInfo = $orderItemShipmentInfo;
        return $this;
    }
    /**
     * Add item to orderItemShipmentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemShipmentInfoList $item
     * @return \StructType\OrderItemShipmentDataList
     */
    public function addToOrderItemShipmentInfo(\StructType\OrderItemShipmentInfoList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemShipmentInfoList) {
            throw new \InvalidArgumentException(sprintf('The orderItemShipmentInfo property can only contain items of type \StructType\OrderItemShipmentInfoList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderItemShipmentInfo[] = $item;
        return $this;
    }
}
