<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemIdentityDataRequest StructType
 * @subpackage Structs
 */
class OrderItemIdentityDataRequest extends AbstractStructBase
{
    /**
     * The orderItemId
     * @var int
     */
    public $orderItemId;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The serialDataList
     * @var \StructType\SerialDataListRequest
     */
    public $serialDataList;
    /**
     * Constructor method for OrderItemIdentityDataRequest
     * @uses OrderItemIdentityDataRequest::setOrderItemId()
     * @uses OrderItemIdentityDataRequest::setProductId()
     * @uses OrderItemIdentityDataRequest::setSerialDataList()
     * @param int $orderItemId
     * @param int $productId
     * @param \StructType\SerialDataListRequest $serialDataList
     */
    public function __construct($orderItemId = null, $productId = null, \StructType\SerialDataListRequest $serialDataList = null)
    {
        $this
            ->setOrderItemId($orderItemId)
            ->setProductId($productId)
            ->setSerialDataList($serialDataList);
    }
    /**
     * Get orderItemId value
     * @return int|null
     */
    public function getOrderItemId()
    {
        return $this->orderItemId;
    }
    /**
     * Set orderItemId value
     * @param int $orderItemId
     * @return \StructType\OrderItemIdentityDataRequest
     */
    public function setOrderItemId($orderItemId = null)
    {
        // validation for constraint: int
        if (!is_null($orderItemId) && !(is_int($orderItemId) || ctype_digit($orderItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderItemId, true), gettype($orderItemId)), __LINE__);
        }
        $this->orderItemId = $orderItemId;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\OrderItemIdentityDataRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get serialDataList value
     * @return \StructType\SerialDataListRequest|null
     */
    public function getSerialDataList()
    {
        return $this->serialDataList;
    }
    /**
     * Set serialDataList value
     * @param \StructType\SerialDataListRequest $serialDataList
     * @return \StructType\OrderItemIdentityDataRequest
     */
    public function setSerialDataList(\StructType\SerialDataListRequest $serialDataList = null)
    {
        $this->serialDataList = $serialDataList;
        return $this;
    }
}
