<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressModel StructType
 * @subpackage Structs
 */
class AddressModel extends AbstractStructBase
{
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * The fullName
     * @var string
     */
    public $fullName;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The district
     * @var string
     */
    public $district;
    /**
     * The postalCode
     * @var string
     */
    public $postalCode;
    /**
     * The gsm
     * @var string
     */
    public $gsm;
    /**
     * Constructor method for AddressModel
     * @uses AddressModel::setAddress()
     * @uses AddressModel::setFullName()
     * @uses AddressModel::setCity()
     * @uses AddressModel::setDistrict()
     * @uses AddressModel::setPostalCode()
     * @uses AddressModel::setGsm()
     * @param string $address
     * @param string $fullName
     * @param string $city
     * @param string $district
     * @param string $postalCode
     * @param string $gsm
     */
    public function __construct($address = null, $fullName = null, $city = null, $district = null, $postalCode = null, $gsm = null)
    {
        $this
            ->setAddress($address)
            ->setFullName($fullName)
            ->setCity($city)
            ->setDistrict($district)
            ->setPostalCode($postalCode)
            ->setGsm($gsm);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\AddressModel
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\AddressModel
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\AddressModel
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\AddressModel
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\AddressModel
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get gsm value
     * @return string|null
     */
    public function getGsm()
    {
        return $this->gsm;
    }
    /**
     * Set gsm value
     * @param string $gsm
     * @return \StructType\AddressModel
     */
    public function setGsm($gsm = null)
    {
        // validation for constraint: string
        if (!is_null($gsm) && !is_string($gsm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gsm)), __LINE__);
        }
        $this->gsm = $gsm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
