<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailedOrderDataList StructType
 * @subpackage Structs
 */
class DetailedOrderDataList extends AbstractStructBase
{
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DetailedOrderData[]
     */
    public $order;
    /**
     * Constructor method for DetailedOrderDataList
     * @uses DetailedOrderDataList::setOrder()
     * @param \StructType\DetailedOrderData[] $order
     */
    public function __construct(array $order = array())
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return \StructType\DetailedOrderData[]|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailedOrderData[] $order
     * @return \StructType\DetailedOrderDataList
     */
    public function setOrder(array $order = array())
    {
        foreach ($order as $detailedOrderDataListOrderItem) {
            // validation for constraint: itemType
            if (!$detailedOrderDataListOrderItem instanceof \StructType\DetailedOrderData) {
                throw new \InvalidArgumentException(sprintf('The order property can only contain items of \StructType\DetailedOrderData, "%s" given', is_object($detailedOrderDataListOrderItem) ? get_class($detailedOrderDataListOrderItem) : gettype($detailedOrderDataListOrderItem)), __LINE__);
            }
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailedOrderData $item
     * @return \StructType\DetailedOrderDataList
     */
    public function addToOrder(\StructType\DetailedOrderData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DetailedOrderData) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of \StructType\DetailedOrderData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DetailedOrderDataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
