<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hediye ServiceType
 * @subpackage Services
 */
class Hediye extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HediyeCekiUygula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HediyeCekiUygula $parameters
     * @return \StructType\HediyeCekiUygulaResponse|bool
     */
    public function HediyeCekiUygula(\StructType\HediyeCekiUygula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HediyeCekiUygula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HediyeCekiOlustur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HediyeCekiOlustur $parameters
     * @return \StructType\HediyeCekiOlusturResponse|bool
     */
    public function HediyeCekiOlustur(\StructType\HediyeCekiOlustur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HediyeCekiOlustur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HediyeCekiOlusturResponse|\StructType\HediyeCekiUygulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
