<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebSiparisDurumLog StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebSiparisDurumLog
 * @subpackage Structs
 */
class WebSiparisDurumLog extends AbstractStructBase
{
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Durum;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisNo;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tarih;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for WebSiparisDurumLog
     * @uses WebSiparisDurumLog::setDurum()
     * @uses WebSiparisDurumLog::setSiparisID()
     * @uses WebSiparisDurumLog::setSiparisNo()
     * @uses WebSiparisDurumLog::setTarih()
     * @uses WebSiparisDurumLog::setUyeID()
     * @param string $durum
     * @param int $siparisID
     * @param string $siparisNo
     * @param string $tarih
     * @param int $uyeID
     */
    public function __construct($durum = null, $siparisID = null, $siparisNo = null, $tarih = null, $uyeID = null)
    {
        $this
            ->setDurum($durum)
            ->setSiparisID($siparisID)
            ->setSiparisNo($siparisNo)
            ->setTarih($tarih)
            ->setUyeID($uyeID);
    }
    /**
     * Get Durum value
     * @return string|null
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \EnumType\WebSiparisDurumlari::valueIsValid()
     * @uses \EnumType\WebSiparisDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \StructType\WebSiparisDurumLog
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebSiparisDurumlari::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebSiparisDurumlari', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \EnumType\WebSiparisDurumlari::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\WebSiparisDurumLog
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisNo()
    {
        return isset($this->SiparisNo) ? $this->SiparisNo : null;
    }
    /**
     * Set SiparisNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisNo
     * @return \StructType\WebSiparisDurumLog
     */
    public function setSiparisNo($siparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($siparisNo) && !is_string($siparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisNo, true), gettype($siparisNo)), __LINE__);
        }
        if (is_null($siparisNo) || (is_array($siparisNo) && empty($siparisNo))) {
            unset($this->SiparisNo);
        } else {
            $this->SiparisNo = $siparisNo;
        }
        return $this;
    }
    /**
     * Get Tarih value
     * @return string|null
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\WebSiparisDurumLog
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\WebSiparisDurumLog
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
}
