<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectSiparisDurumResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SelectSiparisDurumResponse
 * @subpackage Structs
 */
class SelectSiparisDurumResponse extends WebServisResponse
{
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Durum;
    /**
     * The KargoTakipLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoTakipLink;
    /**
     * The KargoTakipNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoTakipNo;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisNo;
    /**
     * The SelectSiparisDurumResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SelectSiparisDurumResponse
     */
    public $SelectSiparisDurumResult;
    /**
     * Constructor method for SelectSiparisDurumResponse
     * @uses SelectSiparisDurumResponse::setDurum()
     * @uses SelectSiparisDurumResponse::setKargoTakipLink()
     * @uses SelectSiparisDurumResponse::setKargoTakipNo()
     * @uses SelectSiparisDurumResponse::setSiparisID()
     * @uses SelectSiparisDurumResponse::setSiparisNo()
     * @uses SelectSiparisDurumResponse::setSelectSiparisDurumResult()
     * @param string $durum
     * @param string $kargoTakipLink
     * @param string $kargoTakipNo
     * @param int $siparisID
     * @param string $siparisNo
     * @param \StructType\SelectSiparisDurumResponse $selectSiparisDurumResult
     */
    public function __construct($durum = null, $kargoTakipLink = null, $kargoTakipNo = null, $siparisID = null, $siparisNo = null, \StructType\SelectSiparisDurumResponse $selectSiparisDurumResult = null)
    {
        $this
            ->setDurum($durum)
            ->setKargoTakipLink($kargoTakipLink)
            ->setKargoTakipNo($kargoTakipNo)
            ->setSiparisID($siparisID)
            ->setSiparisNo($siparisNo)
            ->setSelectSiparisDurumResult($selectSiparisDurumResult);
    }
    /**
     * Get Durum value
     * @return string|null
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \EnumType\WebSiparisDurumlari::valueIsValid()
     * @uses \EnumType\WebSiparisDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \StructType\SelectSiparisDurumResponse
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebSiparisDurumlari::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebSiparisDurumlari', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \EnumType\WebSiparisDurumlari::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get KargoTakipLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoTakipLink()
    {
        return isset($this->KargoTakipLink) ? $this->KargoTakipLink : null;
    }
    /**
     * Set KargoTakipLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoTakipLink
     * @return \StructType\SelectSiparisDurumResponse
     */
    public function setKargoTakipLink($kargoTakipLink = null)
    {
        // validation for constraint: string
        if (!is_null($kargoTakipLink) && !is_string($kargoTakipLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoTakipLink, true), gettype($kargoTakipLink)), __LINE__);
        }
        if (is_null($kargoTakipLink) || (is_array($kargoTakipLink) && empty($kargoTakipLink))) {
            unset($this->KargoTakipLink);
        } else {
            $this->KargoTakipLink = $kargoTakipLink;
        }
        return $this;
    }
    /**
     * Get KargoTakipNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoTakipNo()
    {
        return isset($this->KargoTakipNo) ? $this->KargoTakipNo : null;
    }
    /**
     * Set KargoTakipNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoTakipNo
     * @return \StructType\SelectSiparisDurumResponse
     */
    public function setKargoTakipNo($kargoTakipNo = null)
    {
        // validation for constraint: string
        if (!is_null($kargoTakipNo) && !is_string($kargoTakipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoTakipNo, true), gettype($kargoTakipNo)), __LINE__);
        }
        if (is_null($kargoTakipNo) || (is_array($kargoTakipNo) && empty($kargoTakipNo))) {
            unset($this->KargoTakipNo);
        } else {
            $this->KargoTakipNo = $kargoTakipNo;
        }
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\SelectSiparisDurumResponse
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisNo()
    {
        return isset($this->SiparisNo) ? $this->SiparisNo : null;
    }
    /**
     * Set SiparisNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisNo
     * @return \StructType\SelectSiparisDurumResponse
     */
    public function setSiparisNo($siparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($siparisNo) && !is_string($siparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisNo, true), gettype($siparisNo)), __LINE__);
        }
        if (is_null($siparisNo) || (is_array($siparisNo) && empty($siparisNo))) {
            unset($this->SiparisNo);
        } else {
            $this->SiparisNo = $siparisNo;
        }
        return $this;
    }
    /**
     * Get SelectSiparisDurumResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SelectSiparisDurumResponse|null
     */
    public function getSelectSiparisDurumResult()
    {
        return isset($this->SelectSiparisDurumResult) ? $this->SelectSiparisDurumResult : null;
    }
    /**
     * Set SelectSiparisDurumResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SelectSiparisDurumResponse $selectSiparisDurumResult
     * @return \StructType\SelectSiparisDurumResponse
     */
    public function setSelectSiparisDurumResult(\StructType\SelectSiparisDurumResponse $selectSiparisDurumResult = null)
    {
        if (is_null($selectSiparisDurumResult) || (is_array($selectSiparisDurumResult) && empty($selectSiparisDurumResult))) {
            unset($this->SelectSiparisDurumResult);
        } else {
            $this->SelectSiparisDurumResult = $selectSiparisDurumResult;
        }
        return $this;
    }
}
