<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketPlaceParamsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MarketPlaceParamsRequest
 * @subpackage Structs
 */
class MarketPlaceParamsRequest extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Islem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Islem;
    /**
     * The MarketPlaceParams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketPlaceParams;
    /**
     * The SiparisId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisId;
    /**
     * The SiparisNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisNo;
    /**
     * The Tablo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tablo;
    /**
     * Constructor method for MarketPlaceParamsRequest
     * @uses MarketPlaceParamsRequest::setId()
     * @uses MarketPlaceParamsRequest::setIslem()
     * @uses MarketPlaceParamsRequest::setMarketPlaceParams()
     * @uses MarketPlaceParamsRequest::setSiparisId()
     * @uses MarketPlaceParamsRequest::setSiparisNo()
     * @uses MarketPlaceParamsRequest::setTablo()
     * @param int $id
     * @param int $islem
     * @param string $marketPlaceParams
     * @param int $siparisId
     * @param string $siparisNo
     * @param int $tablo
     */
    public function __construct($id = null, $islem = null, $marketPlaceParams = null, $siparisId = null, $siparisNo = null, $tablo = null)
    {
        $this
            ->setId($id)
            ->setIslem($islem)
            ->setMarketPlaceParams($marketPlaceParams)
            ->setSiparisId($siparisId)
            ->setSiparisNo($siparisNo)
            ->setTablo($tablo);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\MarketPlaceParamsRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Islem value
     * @return int|null
     */
    public function getIslem()
    {
        return $this->Islem;
    }
    /**
     * Set Islem value
     * @param int $islem
     * @return \StructType\MarketPlaceParamsRequest
     */
    public function setIslem($islem = null)
    {
        // validation for constraint: int
        if (!is_null($islem) && !(is_int($islem) || ctype_digit($islem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islem, true), gettype($islem)), __LINE__);
        }
        $this->Islem = $islem;
        return $this;
    }
    /**
     * Get MarketPlaceParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketPlaceParams()
    {
        return isset($this->MarketPlaceParams) ? $this->MarketPlaceParams : null;
    }
    /**
     * Set MarketPlaceParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketPlaceParams
     * @return \StructType\MarketPlaceParamsRequest
     */
    public function setMarketPlaceParams($marketPlaceParams = null)
    {
        // validation for constraint: string
        if (!is_null($marketPlaceParams) && !is_string($marketPlaceParams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketPlaceParams, true), gettype($marketPlaceParams)), __LINE__);
        }
        if (is_null($marketPlaceParams) || (is_array($marketPlaceParams) && empty($marketPlaceParams))) {
            unset($this->MarketPlaceParams);
        } else {
            $this->MarketPlaceParams = $marketPlaceParams;
        }
        return $this;
    }
    /**
     * Get SiparisId value
     * @return int|null
     */
    public function getSiparisId()
    {
        return $this->SiparisId;
    }
    /**
     * Set SiparisId value
     * @param int $siparisId
     * @return \StructType\MarketPlaceParamsRequest
     */
    public function setSiparisId($siparisId = null)
    {
        // validation for constraint: int
        if (!is_null($siparisId) && !(is_int($siparisId) || ctype_digit($siparisId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisId, true), gettype($siparisId)), __LINE__);
        }
        $this->SiparisId = $siparisId;
        return $this;
    }
    /**
     * Get SiparisNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisNo()
    {
        return isset($this->SiparisNo) ? $this->SiparisNo : null;
    }
    /**
     * Set SiparisNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisNo
     * @return \StructType\MarketPlaceParamsRequest
     */
    public function setSiparisNo($siparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($siparisNo) && !is_string($siparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisNo, true), gettype($siparisNo)), __LINE__);
        }
        if (is_null($siparisNo) || (is_array($siparisNo) && empty($siparisNo))) {
            unset($this->SiparisNo);
        } else {
            $this->SiparisNo = $siparisNo;
        }
        return $this;
    }
    /**
     * Get Tablo value
     * @return int|null
     */
    public function getTablo()
    {
        return $this->Tablo;
    }
    /**
     * Set Tablo value
     * @param int $tablo
     * @return \StructType\MarketPlaceParamsRequest
     */
    public function setTablo($tablo = null)
    {
        // validation for constraint: int
        if (!is_null($tablo) && !(is_int($tablo) || ctype_digit($tablo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tablo, true), gettype($tablo)), __LINE__);
        }
        $this->Tablo = $tablo;
        return $this;
    }
}
