<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Siparis ServiceType
 * @subpackage Services
 */
class Siparis extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SiparisPaketleKargoyaGonder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisPaketleKargoyaGonder $parameters
     * @return \StructType\SiparisPaketleKargoyaGonderResponse|bool
     */
    public function SiparisPaketleKargoyaGonder(\StructType\SiparisPaketleKargoyaGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisPaketleKargoyaGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisAnonimlestir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisAnonimlestir $parameters
     * @return \StructType\SiparisAnonimlestirResponse|bool
     */
    public function SiparisAnonimlestir(\StructType\SiparisAnonimlestir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisAnonimlestir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SiparisAnonimlestirResponse|\StructType\SiparisPaketleKargoyaGonderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
