<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSiparisFaturaUrlRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetSiparisFaturaUrlRequest
 * @subpackage Structs
 */
class SetSiparisFaturaUrlRequest extends AbstractStructBase
{
    /**
     * The FaturaUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaturaUrl;
    /**
     * The SiparisId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisId;
    /**
     * Constructor method for SetSiparisFaturaUrlRequest
     * @uses SetSiparisFaturaUrlRequest::setFaturaUrl()
     * @uses SetSiparisFaturaUrlRequest::setSiparisId()
     * @param string $faturaUrl
     * @param int $siparisId
     */
    public function __construct($faturaUrl = null, $siparisId = null)
    {
        $this
            ->setFaturaUrl($faturaUrl)
            ->setSiparisId($siparisId);
    }
    /**
     * Get FaturaUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaturaUrl()
    {
        return isset($this->FaturaUrl) ? $this->FaturaUrl : null;
    }
    /**
     * Set FaturaUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faturaUrl
     * @return \StructType\SetSiparisFaturaUrlRequest
     */
    public function setFaturaUrl($faturaUrl = null)
    {
        // validation for constraint: string
        if (!is_null($faturaUrl) && !is_string($faturaUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaUrl, true), gettype($faturaUrl)), __LINE__);
        }
        if (is_null($faturaUrl) || (is_array($faturaUrl) && empty($faturaUrl))) {
            unset($this->FaturaUrl);
        } else {
            $this->FaturaUrl = $faturaUrl;
        }
        return $this;
    }
    /**
     * Get SiparisId value
     * @return int|null
     */
    public function getSiparisId()
    {
        return $this->SiparisId;
    }
    /**
     * Set SiparisId value
     * @param int $siparisId
     * @return \StructType\SetSiparisFaturaUrlRequest
     */
    public function setSiparisId($siparisId = null)
    {
        // validation for constraint: int
        if (!is_null($siparisId) && !(is_int($siparisId) || ctype_digit($siparisId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisId, true), gettype($siparisId)), __LINE__);
        }
        $this->SiparisId = $siparisId;
        return $this;
    }
}
