<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSubCategoriesRequest StructType
 * @subpackage Structs
 */
class GetSubCategoriesRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The categoryId
     * @var int
     */
    public $categoryId;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastModifiedDate;
    /**
     * Constructor method for GetSubCategoriesRequest
     * @uses GetSubCategoriesRequest::setAuth()
     * @uses GetSubCategoriesRequest::setCategoryId()
     * @uses GetSubCategoriesRequest::setLastModifiedDate()
     * @param \StructType\Authentication $auth
     * @param int $categoryId
     * @param string $lastModifiedDate
     */
    public function __construct(\StructType\Authentication $auth = null, $categoryId = null, $lastModifiedDate = null)
    {
        $this
            ->setAuth($auth)
            ->setCategoryId($categoryId)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetSubCategoriesRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \StructType\GetSubCategoriesRequest
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\GetSubCategoriesRequest
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
}
