<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParentCategoryRequest StructType
 * @subpackage Structs
 */
class GetParentCategoryRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The categoryId
     * @var int
     */
    public $categoryId;
    /**
     * Constructor method for GetParentCategoryRequest
     * @uses GetParentCategoryRequest::setAuth()
     * @uses GetParentCategoryRequest::setCategoryId()
     * @param \StructType\Authentication $auth
     * @param int $categoryId
     */
    public function __construct(\StructType\Authentication $auth = null, $categoryId = null)
    {
        $this
            ->setAuth($auth)
            ->setCategoryId($categoryId);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetParentCategoryRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \StructType\GetParentCategoryRequest
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
}
