<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCategoryAttributesRequest StructType
 * @subpackage Structs
 */
class GetCategoryAttributesRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The categoryId
     * @var int
     */
    public $categoryId;
    /**
     * The pagingData
     * @var \StructType\RequestPagingData
     */
    public $pagingData;
    /**
     * Constructor method for GetCategoryAttributesRequest
     * @uses GetCategoryAttributesRequest::setAuth()
     * @uses GetCategoryAttributesRequest::setCategoryId()
     * @uses GetCategoryAttributesRequest::setPagingData()
     * @param \StructType\Authentication $auth
     * @param int $categoryId
     * @param \StructType\RequestPagingData $pagingData
     */
    public function __construct(\StructType\Authentication $auth = null, $categoryId = null, \StructType\RequestPagingData $pagingData = null)
    {
        $this
            ->setAuth($auth)
            ->setCategoryId($categoryId)
            ->setPagingData($pagingData);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetCategoryAttributesRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \StructType\GetCategoryAttributesRequest
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\RequestPagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\RequestPagingData $pagingData
     * @return \StructType\GetCategoryAttributesRequest
     */
    public function setPagingData(\StructType\RequestPagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
}
