<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCategoryAttributeValueRequest StructType
 * @subpackage Structs
 */
class GetCategoryAttributeValueRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The categoryProductAttributeId
     * @var int
     */
    public $categoryProductAttributeId;
    /**
     * The categoryId
     * @var int
     */
    public $categoryId;
    /**
     * The pagingData
     * @var \StructType\RequestPagingData
     */
    public $pagingData;
    /**
     * Constructor method for GetCategoryAttributeValueRequest
     * @uses GetCategoryAttributeValueRequest::setAuth()
     * @uses GetCategoryAttributeValueRequest::setCategoryProductAttributeId()
     * @uses GetCategoryAttributeValueRequest::setCategoryId()
     * @uses GetCategoryAttributeValueRequest::setPagingData()
     * @param \StructType\Authentication $auth
     * @param int $categoryProductAttributeId
     * @param int $categoryId
     * @param \StructType\RequestPagingData $pagingData
     */
    public function __construct(\StructType\Authentication $auth = null, $categoryProductAttributeId = null, $categoryId = null, \StructType\RequestPagingData $pagingData = null)
    {
        $this
            ->setAuth($auth)
            ->setCategoryProductAttributeId($categoryProductAttributeId)
            ->setCategoryId($categoryId)
            ->setPagingData($pagingData);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetCategoryAttributeValueRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get categoryProductAttributeId value
     * @return int|null
     */
    public function getCategoryProductAttributeId()
    {
        return $this->categoryProductAttributeId;
    }
    /**
     * Set categoryProductAttributeId value
     * @param int $categoryProductAttributeId
     * @return \StructType\GetCategoryAttributeValueRequest
     */
    public function setCategoryProductAttributeId($categoryProductAttributeId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryProductAttributeId) && !(is_int($categoryProductAttributeId) || ctype_digit($categoryProductAttributeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryProductAttributeId, true), gettype($categoryProductAttributeId)), __LINE__);
        }
        $this->categoryProductAttributeId = $categoryProductAttributeId;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \StructType\GetCategoryAttributeValueRequest
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\RequestPagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\RequestPagingData $pagingData
     * @return \StructType\GetCategoryAttributeValueRequest
     */
    public function setPagingData(\StructType\RequestPagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
}
