<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryAttributeList StructType
 * @subpackage Structs
 */
class CategoryAttributeList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryAttributeData[]
     */
    public $attribute;
    /**
     * Constructor method for CategoryAttributeList
     * @uses CategoryAttributeList::setAttribute()
     * @param \StructType\CategoryAttributeData[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\CategoryAttributeData[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryAttributeListAttributeItem) {
            // validation for constraint: itemType
            if (!$categoryAttributeListAttributeItem instanceof \StructType\CategoryAttributeData) {
                $invalidValues[] = is_object($categoryAttributeListAttributeItem) ? get_class($categoryAttributeListAttributeItem) : sprintf('%s(%s)', gettype($categoryAttributeListAttributeItem), var_export($categoryAttributeListAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attribute property can only contain items of type \StructType\CategoryAttributeData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAttributeData[] $attribute
     * @return \StructType\CategoryAttributeList
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAttributeData $item
     * @return \StructType\CategoryAttributeList
     */
    public function addToAttribute(\StructType\CategoryAttributeData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryAttributeData) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of type \StructType\CategoryAttributeData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
}
