<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCategoryAttributesId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCategoryAttributesIdRequest $getCategoryAttributesIdRequest
     * @return \StructType\GetCategoryAttributesIdResponse|bool
     */
    public function GetCategoryAttributesId(\StructType\GetCategoryAttributesIdRequest $getCategoryAttributesIdRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategoryAttributesId($getCategoryAttributesIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategoryAttributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCategoryAttributesRequest $getCategoryAttributesRequest
     * @return \StructType\GetCategoryAttributesResponse|bool
     */
    public function GetCategoryAttributes(\StructType\GetCategoryAttributesRequest $getCategoryAttributesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategoryAttributes($getCategoryAttributesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategoryAttributeValue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCategoryAttributeValueRequest $getCategoryAttributeValueRequest
     * @return \StructType\GetCategoryAttributeValueResponse|bool
     */
    public function GetCategoryAttributeValue(\StructType\GetCategoryAttributeValueRequest $getCategoryAttributeValueRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategoryAttributeValue($getCategoryAttributeValueRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParentCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetParentCategoryRequest $getParentCategoryRequest
     * @return \StructType\GetParentCategoryResponse|bool
     */
    public function GetParentCategory(\StructType\GetParentCategoryRequest $getParentCategoryRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetParentCategory($getParentCategoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopLevelCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopLevelCategoriesRequest $getTopLevelCategoriesRequest
     * @return \StructType\GetTopLevelCategoriesResponse|bool
     */
    public function GetTopLevelCategories(\StructType\GetTopLevelCategoriesRequest $getTopLevelCategoriesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopLevelCategories($getTopLevelCategoriesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubCategoriesRequest $getSubCategoriesRequest
     * @return \StructType\GetSubCategoriesResponse|bool
     */
    public function GetSubCategories(\StructType\GetSubCategoriesRequest $getSubCategoriesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSubCategories($getSubCategoriesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCategoryAttributesIdResponse|\StructType\GetCategoryAttributesResponse|\StructType\GetCategoryAttributeValueResponse|\StructType\GetParentCategoryResponse|\StructType\GetSubCategoriesResponse|\StructType\GetTopLevelCategoriesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
