<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParentCategoryData StructType
 * @subpackage Structs
 */
class ParentCategoryData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The parentCategory
     * @var \StructType\ParentCategory
     */
    public $parentCategory;
    /**
     * Constructor method for ParentCategoryData
     * @uses ParentCategoryData::setId()
     * @uses ParentCategoryData::setName()
     * @uses ParentCategoryData::setParentCategory()
     * @param int $id
     * @param string $name
     * @param \StructType\ParentCategory $parentCategory
     */
    public function __construct($id = null, $name = null, \StructType\ParentCategory $parentCategory = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setParentCategory($parentCategory);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ParentCategoryData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ParentCategoryData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get parentCategory value
     * @return \StructType\ParentCategory|null
     */
    public function getParentCategory()
    {
        return $this->parentCategory;
    }
    /**
     * Set parentCategory value
     * @param \StructType\ParentCategory $parentCategory
     * @return \StructType\ParentCategoryData
     */
    public function setParentCategory(\StructType\ParentCategory $parentCategory = null)
    {
        $this->parentCategory = $parentCategory;
        return $this;
    }
}
