<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSubCategoriesResponse StructType
 * @subpackage Structs
 */
class GetSubCategoriesResponse extends AbstractStructBase
{
    /**
     * The result
     * @var \StructType\ResultInfo
     */
    public $result;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SubCategoryData[]
     */
    public $category;
    /**
     * Constructor method for GetSubCategoriesResponse
     * @uses GetSubCategoriesResponse::setResult()
     * @uses GetSubCategoriesResponse::setCategory()
     * @param \StructType\ResultInfo $result
     * @param \StructType\SubCategoryData[] $category
     */
    public function __construct(\StructType\ResultInfo $result = null, array $category = array())
    {
        $this
            ->setResult($result)
            ->setCategory($category);
    }
    /**
     * Get result value
     * @return \StructType\ResultInfo|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ResultInfo $result
     * @return \StructType\GetSubCategoriesResponse
     */
    public function setResult(\StructType\ResultInfo $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\SubCategoryData[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryForArrayConstraintsFromSetCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getSubCategoriesResponseCategoryItem) {
            // validation for constraint: itemType
            if (!$getSubCategoriesResponseCategoryItem instanceof \StructType\SubCategoryData) {
                $invalidValues[] = is_object($getSubCategoriesResponseCategoryItem) ? get_class($getSubCategoriesResponseCategoryItem) : sprintf('%s(%s)', gettype($getSubCategoriesResponseCategoryItem), var_export($getSubCategoriesResponseCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category property can only contain items of type \StructType\SubCategoryData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\SubCategoryData[] $category
     * @return \StructType\GetSubCategoriesResponse
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryArrayErrorMessage = self::validateCategoryForArrayConstraintsFromSetCategory($category))) {
            throw new \InvalidArgumentException($categoryArrayErrorMessage, __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\SubCategoryData $item
     * @return \StructType\GetSubCategoriesResponse
     */
    public function addToCategory(\StructType\SubCategoryData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubCategoryData) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of type \StructType\SubCategoryData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
}
