<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryAttributeValueList StructType
 * @subpackage Structs
 */
class CategoryAttributeValueList extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CategoryAttributeValueData[]
     */
    public $value;
    /**
     * Constructor method for CategoryAttributeValueList
     * @uses CategoryAttributeValueList::setValue()
     * @param \StructType\CategoryAttributeValueData[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get value value
     * @return \StructType\CategoryAttributeValueData[]|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryAttributeValueListValueItem) {
            // validation for constraint: itemType
            if (!$categoryAttributeValueListValueItem instanceof \StructType\CategoryAttributeValueData) {
                $invalidValues[] = is_object($categoryAttributeValueListValueItem) ? get_class($categoryAttributeValueListValueItem) : sprintf('%s(%s)', gettype($categoryAttributeValueListValueItem), var_export($categoryAttributeValueListValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The value property can only contain items of type \StructType\CategoryAttributeValueData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAttributeValueData[] $value
     * @return \StructType\CategoryAttributeValueList
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAttributeValueData $item
     * @return \StructType\CategoryAttributeValueList
     */
    public function addToValue(\StructType\CategoryAttributeValueData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryAttributeValueData) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of type \StructType\CategoryAttributeValueData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
}
