<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryData StructType
 * @subpackage Structs
 */
class CategoryData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The parentCategory
     * @var \StructType\CategoryData
     */
    public $parentCategory;
    /**
     * The subCategoryList
     * @var \StructType\SubCategoryList
     */
    public $subCategoryList;
    /**
     * The attributeList
     * @var \StructType\CategoryAttributeList
     */
    public $attributeList;
    /**
     * The metadata
     * @var \StructType\PagingData
     */
    public $metadata;
    /**
     * Constructor method for CategoryData
     * @uses CategoryData::setId()
     * @uses CategoryData::setName()
     * @uses CategoryData::setParentCategory()
     * @uses CategoryData::setSubCategoryList()
     * @uses CategoryData::setAttributeList()
     * @uses CategoryData::setMetadata()
     * @param int $id
     * @param string $name
     * @param \StructType\CategoryData $parentCategory
     * @param \StructType\SubCategoryList $subCategoryList
     * @param \StructType\CategoryAttributeList $attributeList
     * @param \StructType\PagingData $metadata
     */
    public function __construct($id = null, $name = null, \StructType\CategoryData $parentCategory = null, \StructType\SubCategoryList $subCategoryList = null, \StructType\CategoryAttributeList $attributeList = null, \StructType\PagingData $metadata = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setParentCategory($parentCategory)
            ->setSubCategoryList($subCategoryList)
            ->setAttributeList($attributeList)
            ->setMetadata($metadata);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\CategoryData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CategoryData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get parentCategory value
     * @return \StructType\CategoryData|null
     */
    public function getParentCategory()
    {
        return $this->parentCategory;
    }
    /**
     * Set parentCategory value
     * @param \StructType\CategoryData $parentCategory
     * @return \StructType\CategoryData
     */
    public function setParentCategory(\StructType\CategoryData $parentCategory = null)
    {
        $this->parentCategory = $parentCategory;
        return $this;
    }
    /**
     * Get subCategoryList value
     * @return \StructType\SubCategoryList|null
     */
    public function getSubCategoryList()
    {
        return $this->subCategoryList;
    }
    /**
     * Set subCategoryList value
     * @param \StructType\SubCategoryList $subCategoryList
     * @return \StructType\CategoryData
     */
    public function setSubCategoryList(\StructType\SubCategoryList $subCategoryList = null)
    {
        $this->subCategoryList = $subCategoryList;
        return $this;
    }
    /**
     * Get attributeList value
     * @return \StructType\CategoryAttributeList|null
     */
    public function getAttributeList()
    {
        return $this->attributeList;
    }
    /**
     * Set attributeList value
     * @param \StructType\CategoryAttributeList $attributeList
     * @return \StructType\CategoryData
     */
    public function setAttributeList(\StructType\CategoryAttributeList $attributeList = null)
    {
        $this->attributeList = $attributeList;
        return $this;
    }
    /**
     * Get metadata value
     * @return \StructType\PagingData|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }
    /**
     * Set metadata value
     * @param \StructType\PagingData $metadata
     * @return \StructType\CategoryData
     */
    public function setMetadata(\StructType\PagingData $metadata = null)
    {
        $this->metadata = $metadata;
        return $this;
    }
}
