<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryAttributeValueData StructType
 * @subpackage Structs
 */
class CategoryAttributeValueData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The dependedName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dependedName;
    /**
     * Constructor method for CategoryAttributeValueData
     * @uses CategoryAttributeValueData::setId()
     * @uses CategoryAttributeValueData::setName()
     * @uses CategoryAttributeValueData::setDependedName()
     * @param int $id
     * @param string $name
     * @param string $dependedName
     */
    public function __construct($id = null, $name = null, $dependedName = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setDependedName($dependedName);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\CategoryAttributeValueData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CategoryAttributeValueData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dependedName value
     * @return string|null
     */
    public function getDependedName()
    {
        return $this->dependedName;
    }
    /**
     * Set dependedName value
     * @param string $dependedName
     * @return \StructType\CategoryAttributeValueData
     */
    public function setDependedName($dependedName = null)
    {
        // validation for constraint: string
        if (!is_null($dependedName) && !is_string($dependedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependedName, true), gettype($dependedName)), __LINE__);
        }
        $this->dependedName = $dependedName;
        return $this;
    }
}
