<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubCategoryList StructType
 * @subpackage Structs
 */
class SubCategoryList extends AbstractStructBase
{
    /**
     * The subCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubCategory[]
     */
    public $subCategory;
    /**
     * Constructor method for SubCategoryList
     * @uses SubCategoryList::setSubCategory()
     * @param \StructType\SubCategory[] $subCategory
     */
    public function __construct(array $subCategory = array())
    {
        $this
            ->setSubCategory($subCategory);
    }
    /**
     * Get subCategory value
     * @return \StructType\SubCategory[]|null
     */
    public function getSubCategory()
    {
        return $this->subCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setSubCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubCategoryForArrayConstraintsFromSetSubCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subCategoryListSubCategoryItem) {
            // validation for constraint: itemType
            if (!$subCategoryListSubCategoryItem instanceof \StructType\SubCategory) {
                $invalidValues[] = is_object($subCategoryListSubCategoryItem) ? get_class($subCategoryListSubCategoryItem) : sprintf('%s(%s)', gettype($subCategoryListSubCategoryItem), var_export($subCategoryListSubCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subCategory property can only contain items of type \StructType\SubCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SubCategory[] $subCategory
     * @return \StructType\SubCategoryList
     */
    public function setSubCategory(array $subCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($subCategoryArrayErrorMessage = self::validateSubCategoryForArrayConstraintsFromSetSubCategory($subCategory))) {
            throw new \InvalidArgumentException($subCategoryArrayErrorMessage, __LINE__);
        }
        $this->subCategory = $subCategory;
        return $this;
    }
    /**
     * Add item to subCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SubCategory $item
     * @return \StructType\SubCategoryList
     */
    public function addToSubCategory(\StructType\SubCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubCategory) {
            throw new \InvalidArgumentException(sprintf('The subCategory property can only contain items of type \StructType\SubCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subCategory[] = $item;
        return $this;
    }
}
