<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubCategoryData StructType
 * @subpackage Structs
 */
class SubCategoryData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The subCategoryList
     * @var \StructType\SubCategoryList
     */
    public $subCategoryList;
    /**
     * Constructor method for SubCategoryData
     * @uses SubCategoryData::setId()
     * @uses SubCategoryData::setName()
     * @uses SubCategoryData::setSubCategoryList()
     * @param int $id
     * @param string $name
     * @param \StructType\SubCategoryList $subCategoryList
     */
    public function __construct($id = null, $name = null, \StructType\SubCategoryList $subCategoryList = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setSubCategoryList($subCategoryList);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\SubCategoryData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SubCategoryData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get subCategoryList value
     * @return \StructType\SubCategoryList|null
     */
    public function getSubCategoryList()
    {
        return $this->subCategoryList;
    }
    /**
     * Set subCategoryList value
     * @param \StructType\SubCategoryList $subCategoryList
     * @return \StructType\SubCategoryData
     */
    public function setSubCategoryList(\StructType\SubCategoryList $subCategoryList = null)
    {
        $this->subCategoryList = $subCategoryList;
        return $this;
    }
}
