<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryProductAttributeData StructType
 * @subpackage Structs
 */
class CategoryProductAttributeData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The mandatory
     * @var bool
     */
    public $mandatory;
    /**
     * The multipleSelect
     * @var bool
     */
    public $multipleSelect;
    /**
     * The variant
     * @var bool
     */
    public $variant;
    /**
     * Constructor method for CategoryProductAttributeData
     * @uses CategoryProductAttributeData::setId()
     * @uses CategoryProductAttributeData::setName()
     * @uses CategoryProductAttributeData::setMandatory()
     * @uses CategoryProductAttributeData::setMultipleSelect()
     * @uses CategoryProductAttributeData::setVariant()
     * @param int $id
     * @param string $name
     * @param bool $mandatory
     * @param bool $multipleSelect
     * @param bool $variant
     */
    public function __construct($id = null, $name = null, $mandatory = null, $multipleSelect = null, $variant = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setMandatory($mandatory)
            ->setMultipleSelect($multipleSelect)
            ->setVariant($variant);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\CategoryProductAttributeData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CategoryProductAttributeData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }
    /**
     * Set mandatory value
     * @param bool $mandatory
     * @return \StructType\CategoryProductAttributeData
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->mandatory = $mandatory;
        return $this;
    }
    /**
     * Get multipleSelect value
     * @return bool|null
     */
    public function getMultipleSelect()
    {
        return $this->multipleSelect;
    }
    /**
     * Set multipleSelect value
     * @param bool $multipleSelect
     * @return \StructType\CategoryProductAttributeData
     */
    public function setMultipleSelect($multipleSelect = null)
    {
        // validation for constraint: boolean
        if (!is_null($multipleSelect) && !is_bool($multipleSelect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multipleSelect, true), gettype($multipleSelect)), __LINE__);
        }
        $this->multipleSelect = $multipleSelect;
        return $this;
    }
    /**
     * Get variant value
     * @return bool|null
     */
    public function getVariant()
    {
        return $this->variant;
    }
    /**
     * Set variant value
     * @param bool $variant
     * @return \StructType\CategoryProductAttributeData
     */
    public function setVariant($variant = null)
    {
        // validation for constraint: boolean
        if (!is_null($variant) && !is_bool($variant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($variant, true), gettype($variant)), __LINE__);
        }
        $this->variant = $variant;
        return $this;
    }
}
