<?php

namespace GlsApi\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ade Service
 * @subpackage Services
 */
class Ade extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeLogin
     * Meta information extracted from the WSDL
     * - documentation: Login to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeLogin $parameters
     * @return \GlsApi\Struct\AdeLoginResponse|bool
     */
    public function adeLogin(\GlsApi\Struct\AdeLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLoginIntegrator
     * Meta information extracted from the WSDL
     * - documentation: Login integrator to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeLoginIntegrator $parameters
     * @return \GlsApi\Struct\AdeLoginIntegratorResponse|bool
     */
    public function adeLoginIntegrator(\GlsApi\Struct\AdeLoginIntegrator $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLoginIntegrator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLoginByLocalizationCode
     * Meta information extracted from the WSDL
     * - documentation: Login to ADE Plus by Localization Code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeLoginByLocalizationCode $parameters
     * @return \GlsApi\Struct\AdeLoginByLocalizationCodeResponse|bool
     */
    public function adeLoginByLocalizationCode(\GlsApi\Struct\AdeLoginByLocalizationCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLoginByLocalizationCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLogout
     * Meta information extracted from the WSDL
     * - documentation: Logout from ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeLogout $parameters
     * @return \GlsApi\Struct\AdeLogoutResponse|bool
     */
    public function adeLogout(\GlsApi\Struct\AdeLogout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_Insert
     * Meta information extracted from the WSDL
     * - documentation: Insert consignment to preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_Insert $parameters
     * @return \GlsApi\Struct\AdePreparingBox_InsertResponse|bool
     */
    public function adePreparingBox_Insert(\GlsApi\Struct\AdePreparingBox_Insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_Insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_InsertExt
     * Meta information extracted from the WSDL
     * - documentation: Insert consignment to preparing box (version with Customs Declaration).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_InsertExt $parameters
     * @return \GlsApi\Struct\AdePreparingBox_InsertExtResponse|bool
     */
    public function adePreparingBox_InsertExt(\GlsApi\Struct\AdePreparingBox_InsertExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_InsertExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetConsignIDs $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetConsignIDsResponse|bool
     */
    public function adePreparingBox_GetConsignIDs(\GlsApi\Struct\AdePreparingBox_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_DeleteConsign
     * Meta information extracted from the WSDL
     * - documentation: Delete consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_DeleteConsign $parameters
     * @return \GlsApi\Struct\AdePreparingBox_DeleteConsignResponse|bool
     */
    public function adePreparingBox_DeleteConsign(\GlsApi\Struct\AdePreparingBox_DeleteConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_DeleteConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetConsign $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetConsignResponse|bool
     */
    public function adePreparingBox_GetConsign(\GlsApi\Struct\AdePreparingBox_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetConsignLabels $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetConsignLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignLabels(\GlsApi\Struct\AdePreparingBox_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetConsignLabelsExt $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetConsignLabelsExtResponse|bool
     */
    public function adePreparingBox_GetConsignLabelsExt(\GlsApi\Struct\AdePreparingBox_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignDocs
     * Meta information extracted from the WSDL
     * - documentation: Get all consignment documents from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetConsignDocs $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetConsignDocsResponse|bool
     */
    public function adePreparingBox_GetConsignDocs(\GlsApi\Struct\AdePreparingBox_GetConsignDocs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignDocs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (via consign ids array)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetConsignsLabels $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetConsignsLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignsLabels(\GlsApi\Struct\AdePreparingBox_GetConsignsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from preparing box
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetParcelLabel $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetParcelLabelResponse|bool
     */
    public function adePreparingBox_GetParcelLabel(\GlsApi\Struct\AdePreparingBox_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_Create
     * Meta information extracted from the WSDL
     * - documentation: Create pickup from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_Create $parameters
     * @return \GlsApi\Struct\AdePickup_CreateResponse|bool
     */
    public function adePickup_Create(\GlsApi\Struct\AdePickup_Create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: List avail pickups.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetIDs $parameters
     * @return \GlsApi\Struct\AdePickup_GetIDsResponse|bool
     */
    public function adePickup_GetIDs(\GlsApi\Struct\AdePickup_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_Get
     * Meta information extracted from the WSDL
     * - documentation: Get info about pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_Get $parameters
     * @return \GlsApi\Struct\AdePickup_GetResponse|bool
     */
    public function adePickup_Get(\GlsApi\Struct\AdePickup_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignBinds
     * Meta information extracted from the WSDL
     * - documentation: List of shipment IDs with their associated/bind shipment IDs from preparing box for a single shipment confirmation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetConsignBinds $parameters
     * @return \GlsApi\Struct\AdePickup_GetConsignBindsResponse|bool
     */
    public function adePickup_GetConsignBinds(\GlsApi\Struct\AdePickup_GetConsignBinds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignBinds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetConsignIDs $parameters
     * @return \GlsApi\Struct\AdePickup_GetConsignIDsResponse|bool
     */
    public function adePickup_GetConsignIDs(\GlsApi\Struct\AdePickup_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetConsign $parameters
     * @return \GlsApi\Struct\AdePickup_GetConsignResponse|bool
     */
    public function adePickup_GetConsign(\GlsApi\Struct\AdePickup_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetReceipt
     * Meta information extracted from the WSDL
     * - documentation: Get receipt from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetReceipt $parameters
     * @return \GlsApi\Struct\AdePickup_GetReceiptResponse|bool
     */
    public function adePickup_GetReceipt(\GlsApi\Struct\AdePickup_GetReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetLabels $parameters
     * @return \GlsApi\Struct\AdePickup_GetLabelsResponse|bool
     */
    public function adePickup_GetLabels(\GlsApi\Struct\AdePickup_GetLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetIdent
     * Meta information extracted from the WSDL
     * - documentation: Get ident document from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetIdent $parameters
     * @return \GlsApi\Struct\AdePickup_GetIdentResponse|bool
     */
    public function adePickup_GetIdent(\GlsApi\Struct\AdePickup_GetIdent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIdent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetConsignLabels $parameters
     * @return \GlsApi\Struct\AdePickup_GetConsignLabelsResponse|bool
     */
    public function adePickup_GetConsignLabels(\GlsApi\Struct\AdePickup_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetConsignLabelsExt $parameters
     * @return \GlsApi\Struct\AdePickup_GetConsignLabelsExtResponse|bool
     */
    public function adePickup_GetConsignLabelsExt(\GlsApi\Struct\AdePickup_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from pickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetParcelLabel $parameters
     * @return \GlsApi\Struct\AdePickup_GetParcelLabelResponse|bool
     */
    public function adePickup_GetParcelLabel(\GlsApi\Struct\AdePickup_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get parcels labels from pickup (array nums on input)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetParcelsLabels $parameters
     * @return \GlsApi\Struct\AdePickup_GetParcelsLabelsResponse|bool
     */
    public function adePickup_GetParcelsLabels(\GlsApi\Struct\AdePickup_GetParcelsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_ParcelNumberSearch
     * Meta information extracted from the WSDL
     * - documentation: Search for consignment based on number of parcel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_ParcelNumberSearch $parameters
     * @return \GlsApi\Struct\AdePickup_ParcelNumberSearchResponse|bool
     */
    public function adePickup_ParcelNumberSearch(\GlsApi\Struct\AdePickup_ParcelNumberSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_ParcelNumberSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePartner_GetParcelNumber
     * Meta information extracted from the WSDL
     * - documentation: Search for partner parcel number based on GLS parcel number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePartner_GetParcelNumber $parameters
     * @return \GlsApi\Struct\AdePartner_GetParcelNumberResponse|bool
     */
    public function adePartner_GetParcelNumber(\GlsApi\Struct\AdePartner_GetParcelNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePartner_GetParcelNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeTrackID_Get
     * Meta information extracted from the WSDL
     * - documentation: Search for TrackID based on GLS parcel number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeTrackID_Get $parameters
     * @return \GlsApi\Struct\AdeTrackID_GetResponse|bool
     */
    public function adeTrackID_Get(\GlsApi\Struct\AdeTrackID_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeTrackID_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: Get profiles info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeProfile_GetIDs $parameters
     * @return \GlsApi\Struct\AdeProfile_GetIDsResponse|bool
     */
    public function adeProfile_GetIDs(\GlsApi\Struct\AdeProfile_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active profile info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeProfile_GetActive $parameters
     * @return \GlsApi\Struct\AdeProfile_GetActiveResponse|bool
     */
    public function adeProfile_GetActive(\GlsApi\Struct\AdeProfile_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_Change
     * Meta information extracted from the WSDL
     * - documentation: Change profile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeProfile_Change $parameters
     * @return \GlsApi\Struct\AdeProfile_ChangeResponse|bool
     */
    public function adeProfile_Change(\GlsApi\Struct\AdeProfile_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active language.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeLang_GetActive $parameters
     * @return \GlsApi\Struct\AdeLang_GetActiveResponse|bool
     */
    public function adeLang_GetActive(\GlsApi\Struct\AdeLang_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_Change
     * Meta information extracted from the WSDL
     * - documentation: Change language
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeLang_Change $parameters
     * @return \GlsApi\Struct\AdeLang_ChangeResponse|bool
     */
    public function adeLang_Change(\GlsApi\Struct\AdeLang_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePfc_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePfc_GetStatus $parameters
     * @return \GlsApi\Struct\AdePfc_GetStatusResponse|bool
     */
    public function adePfc_GetStatus(\GlsApi\Struct\AdePfc_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePfc_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePfc_GetDictionary $parameters
     * @return \GlsApi\Struct\AdePfc_GetDictionaryResponse|bool
     */
    public function adePfc_GetDictionary(\GlsApi\Struct\AdePfc_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeSendAddr_GetStatus $parameters
     * @return \GlsApi\Struct\AdeSendAddr_GetStatusResponse|bool
     */
    public function adeSendAddr_GetStatus(\GlsApi\Struct\AdeSendAddr_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeSendAddr_GetDictionary $parameters
     * @return \GlsApi\Struct\AdeSendAddr_GetDictionaryResponse|bool
     */
    public function adeSendAddr_GetDictionary(\GlsApi\Struct\AdeSendAddr_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetAllowed
     * Meta information extracted from the WSDL
     * - documentation: Get allowed services for user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeServices_GetAllowed $parameters
     * @return \GlsApi\Struct\AdeServices_GetAllowedResponse|bool
     */
    public function adeServices_GetAllowed(\GlsApi\Struct\AdeServices_GetAllowed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetAllowed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetMaxCOD
     * Meta information extracted from the WSDL
     * - documentation: Return maximum amount of COD.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeServices_GetMaxCOD $parameters
     * @return \GlsApi\Struct\AdeServices_GetMaxCODResponse|bool
     */
    public function adeServices_GetMaxCOD(\GlsApi\Struct\AdeServices_GetMaxCOD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetMaxCOD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetMaxParcelWeights
     * Meta information extracted from the WSDL
     * - documentation: Return maximum parcel weights (national and international).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeServices_GetMaxParcelWeights $parameters
     * @return \GlsApi\Struct\AdeServices_GetMaxParcelWeightsResponse|bool
     */
    public function adeServices_GetMaxParcelWeights(\GlsApi\Struct\AdeServices_GetMaxParcelWeights $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetMaxParcelWeights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetGuaranteed
     * Meta information extracted from the WSDL
     * - documentation: Get guaranteed services for given zip code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeServices_GetGuaranteed $parameters
     * @return \GlsApi\Struct\AdeServices_GetGuaranteedResponse|bool
     */
    public function adeServices_GetGuaranteed(\GlsApi\Struct\AdeServices_GetGuaranteed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetGuaranteed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesSDS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SDS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeServices_GetCountriesSDS $parameters
     * @return \GlsApi\Struct\AdeServices_GetCountriesSDSResponse|bool
     */
    public function adeServices_GetCountriesSDS(\GlsApi\Struct\AdeServices_GetCountriesSDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesSRS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SRS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeServices_GetCountriesSRS $parameters
     * @return \GlsApi\Struct\AdeServices_GetCountriesSRSResponse|bool
     */
    public function adeServices_GetCountriesSRS(\GlsApi\Struct\AdeServices_GetCountriesSRS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSRS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesCDX
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries, maximum CDX amount and currency supporting CDX service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeServices_GetCountriesCDX $parameters
     * @return \GlsApi\Struct\AdeServices_GetCountriesCDXResponse|bool
     */
    public function adeServices_GetCountriesCDX(\GlsApi\Struct\AdeServices_GetCountriesCDX $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesCDX($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeZip_GetCity
     * Meta information extracted from the WSDL
     * - documentation: Search for city.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeZip_GetCity $parameters
     * @return \GlsApi\Struct\AdeZip_GetCityResponse|bool
     */
    public function adeZip_GetCity(\GlsApi\Struct\AdeZip_GetCity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_GetCity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeZip_CustomsRequired
     * Meta information extracted from the WSDL
     * - documentation: Search for custom declaration requirements.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeZip_CustomsRequired $parameters
     * @return \GlsApi\Struct\AdeZip_CustomsRequiredResponse|bool
     */
    public function adeZip_CustomsRequired(\GlsApi\Struct\AdeZip_CustomsRequired $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_CustomsRequired($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeOption_Get
     * Meta information extracted from the WSDL
     * - documentation: Get system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeOption_Get $parameters
     * @return \GlsApi\Struct\AdeOption_GetResponse|bool
     */
    public function adeOption_Get(\GlsApi\Struct\AdeOption_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeOption_Set
     * Meta information extracted from the WSDL
     * - documentation: Set system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeOption_Set $parameters
     * @return \GlsApi\Struct\AdeOption_SetResponse|bool
     */
    public function adeOption_Set(\GlsApi\Struct\AdeOption_Set $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Set($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by zip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeParcelShop_SearchByZip $parameters
     * @return \GlsApi\Struct\AdeParcelShop_SearchByZipResponse|bool
     */
    public function adeParcelShop_SearchByZip(\GlsApi\Struct\AdeParcelShop_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_SearchByID
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by ID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeParcelShop_SearchByID $parameters
     * @return \GlsApi\Struct\AdeParcelShop_SearchByIDResponse|bool
     */
    public function adeParcelShop_SearchByID(\GlsApi\Struct\AdeParcelShop_SearchByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_SearchByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeParcelShop_GetByCountry $parameters
     * @return \GlsApi\Struct\AdeParcelShop_GetByCountryResponse|bool
     */
    public function adeParcelShop_GetByCountry(\GlsApi\Struct\AdeParcelShop_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeParcelShop2_GetByCountry $parameters
     * @return \GlsApi\Struct\AdeParcelShop2_GetByCountryResponse|bool
     */
    public function adeParcelShop2_GetByCountry(\GlsApi\Struct\AdeParcelShop2_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by Zip (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeParcelShop2_SearchByZip $parameters
     * @return \GlsApi\Struct\AdeParcelShop2_SearchByZipResponse|bool
     */
    public function adeParcelShop2_SearchByZip(\GlsApi\Struct\AdeParcelShop2_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get consignment customs declarations from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePreparingBox_GetConsignCustomsDec $parameters
     * @return \GlsApi\Struct\AdePreparingBox_GetConsignCustomsDecResponse|bool
     */
    public function adePreparingBox_GetConsignCustomsDec(\GlsApi\Struct\AdePreparingBox_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get customs declarations for consignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetConsignCustomsDec $parameters
     * @return \GlsApi\Struct\AdePickup_GetConsignCustomsDecResponse|bool
     */
    public function adePickup_GetConsignCustomsDec(\GlsApi\Struct\AdePickup_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignPODs
     * Meta information extracted from the WSDL
     * - documentation: Get PODs pdf files from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePickup_GetConsignPODs $parameters
     * @return \GlsApi\Struct\AdePickup_GetConsignPODsResponse|bool
     */
    public function adePickup_GetConsignPODs(\GlsApi\Struct\AdePickup_GetConsignPODs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignPODs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePOD_Get
     * Meta information extracted from the WSDL
     * - documentation: Get POD pdf file for parcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdePOD_Get $parameters
     * @return \GlsApi\Struct\AdePOD_GetResponse|bool
     */
    public function adePOD_Get(\GlsApi\Struct\AdePOD_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePOD_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeCourier_Order
     * Meta information extracted from the WSDL
     * - documentation: Order courier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\AdeCourier_Order $parameters
     * @return \GlsApi\Struct\AdeCourier_OrderResponse|bool
     */
    public function adeCourier_Order(\GlsApi\Struct\AdeCourier_Order $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeCourier_Order($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsApi\Struct\AdeCourier_OrderResponse|\GlsApi\Struct\AdeLang_ChangeResponse|\GlsApi\Struct\AdeLang_GetActiveResponse|\GlsApi\Struct\AdeLoginByLocalizationCodeResponse|\GlsApi\Struct\AdeLoginIntegratorResponse|\GlsApi\Struct\AdeLoginResponse|\GlsApi\Struct\AdeLogoutResponse|\GlsApi\Struct\AdeOption_GetResponse|\GlsApi\Struct\AdeOption_SetResponse|\GlsApi\Struct\AdeParcelShop2_GetByCountryResponse|\GlsApi\Struct\AdeParcelShop2_SearchByZipResponse|\GlsApi\Struct\AdeParcelShop_GetByCountryResponse|\GlsApi\Struct\AdeParcelShop_SearchByIDResponse|\GlsApi\Struct\AdeParcelShop_SearchByZipResponse|\GlsApi\Struct\AdePartner_GetParcelNumberResponse|\GlsApi\Struct\AdePfc_GetDictionaryResponse|\GlsApi\Struct\AdePfc_GetStatusResponse|\GlsApi\Struct\AdePickup_CreateResponse|\GlsApi\Struct\AdePickup_GetConsignBindsResponse|\GlsApi\Struct\AdePickup_GetConsignCustomsDecResponse|\GlsApi\Struct\AdePickup_GetConsignIDsResponse|\GlsApi\Struct\AdePickup_GetConsignLabelsExtResponse|\GlsApi\Struct\AdePickup_GetConsignLabelsResponse|\GlsApi\Struct\AdePickup_GetConsignPODsResponse|\GlsApi\Struct\AdePickup_GetConsignResponse|\GlsApi\Struct\AdePickup_GetIdentResponse|\GlsApi\Struct\AdePickup_GetIDsResponse|\GlsApi\Struct\AdePickup_GetLabelsResponse|\GlsApi\Struct\AdePickup_GetParcelLabelResponse|\GlsApi\Struct\AdePickup_GetParcelsLabelsResponse|\GlsApi\Struct\AdePickup_GetReceiptResponse|\GlsApi\Struct\AdePickup_GetResponse|\GlsApi\Struct\AdePickup_ParcelNumberSearchResponse|\GlsApi\Struct\AdePOD_GetResponse|\GlsApi\Struct\AdePreparingBox_DeleteConsignResponse|\GlsApi\Struct\AdePreparingBox_GetConsignCustomsDecResponse|\GlsApi\Struct\AdePreparingBox_GetConsignDocsResponse|\GlsApi\Struct\AdePreparingBox_GetConsignIDsResponse|\GlsApi\Struct\AdePreparingBox_GetConsignLabelsExtResponse|\GlsApi\Struct\AdePreparingBox_GetConsignLabelsResponse|\GlsApi\Struct\AdePreparingBox_GetConsignResponse|\GlsApi\Struct\AdePreparingBox_GetConsignsLabelsResponse|\GlsApi\Struct\AdePreparingBox_GetParcelLabelResponse|\GlsApi\Struct\AdePreparingBox_InsertExtResponse|\GlsApi\Struct\AdePreparingBox_InsertResponse|\GlsApi\Struct\AdeProfile_ChangeResponse|\GlsApi\Struct\AdeProfile_GetActiveResponse|\GlsApi\Struct\AdeProfile_GetIDsResponse|\GlsApi\Struct\AdeSendAddr_GetDictionaryResponse|\GlsApi\Struct\AdeSendAddr_GetStatusResponse|\GlsApi\Struct\AdeServices_GetAllowedResponse|\GlsApi\Struct\AdeServices_GetCountriesCDXResponse|\GlsApi\Struct\AdeServices_GetCountriesSDSResponse|\GlsApi\Struct\AdeServices_GetCountriesSRSResponse|\GlsApi\Struct\AdeServices_GetGuaranteedResponse|\GlsApi\Struct\AdeServices_GetMaxCODResponse|\GlsApi\Struct\AdeServices_GetMaxParcelWeightsResponse|\GlsApi\Struct\AdeTrackID_GetResponse|\GlsApi\Struct\AdeZip_CustomsRequiredResponse|\GlsApi\Struct\AdeZip_GetCityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
