<?php

namespace GlsApi;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'cSession' => '\\GlsApi\\Struct\\CSession',
            'cConsign' => '\\GlsApi\\Struct\\CConsign',
            'cSenderAddress' => '\\GlsApi\\Struct\\CSenderAddress',
            'cServicesBool' => '\\GlsApi\\Struct\\CServicesBool',
            'cServiceDAW' => '\\GlsApi\\Struct\\CServiceDAW',
            'cServiceIDENT' => '\\GlsApi\\Struct\\CServiceIDENT',
            'cServicePPE' => '\\GlsApi\\Struct\\CServicePPE',
            'cServiceSDS' => '\\GlsApi\\Struct\\CServiceSDS',
            'cParcelsArray' => '\\GlsApi\\Array\\CParcelsArray',
            'cParcel' => '\\GlsApi\\Struct\\CParcel',
            'cID' => '\\GlsApi\\Struct\\CID',
            'cConsignExt' => '\\GlsApi\\Struct\\CConsignExt',
            'cCustomsDeclaration' => '\\GlsApi\\Struct\\CCustomsDeclaration',
            'cCustomsAttachedFilesArray' => '\\GlsApi\\Array\\CCustomsAttachedFilesArray',
            'cCustomsAttachedFile' => '\\GlsApi\\Struct\\CCustomsAttachedFile',
            'cCustomsArticlesArray' => '\\GlsApi\\Array\\CCustomsArticlesArray',
            'cCustomsArticle' => '\\GlsApi\\Struct\\CCustomsArticle',
            'cConsignsIDsArray' => '\\GlsApi\\Array\\CConsignsIDsArray',
            'cLabels' => '\\GlsApi\\Struct\\CLabels',
            'cLabelsArray' => '\\GlsApi\\Array\\CLabelsArray',
            'cLabel' => '\\GlsApi\\Struct\\CLabel',
            'cLabelsIdent' => '\\GlsApi\\Struct\\CLabelsIdent',
            'cPickupsIDsArray' => '\\GlsApi\\Array\\CPickupsIDsArray',
            'cPickup' => '\\GlsApi\\Struct\\CPickup',
            'cConsignBindIDsArray' => '\\GlsApi\\Array\\CConsignBindIDsArray',
            'cConsignBindIDs' => '\\GlsApi\\Struct\\CConsignBindIDs',
            'cReceipt' => '\\GlsApi\\Struct\\CReceipt',
            'cIdent' => '\\GlsApi\\Struct\\CIdent',
            'cStringArray' => '\\GlsApi\\Array\\CStringArray',
            'cPartnerParcelNumber' => '\\GlsApi\\Struct\\CPartnerParcelNumber',
            'cTrackID' => '\\GlsApi\\Struct\\CTrackID',
            'cProfilesArray' => '\\GlsApi\\Array\\CProfilesArray',
            'cProfile' => '\\GlsApi\\Struct\\CProfile',
            'cLang' => '\\GlsApi\\Struct\\CLang',
            'cStatus' => '\\GlsApi\\Struct\\CStatus',
            'cSenderAddressArray' => '\\GlsApi\\Array\\CSenderAddressArray',
            'cServices' => '\\GlsApi\\Struct\\CServices',
            'cCODMax' => '\\GlsApi\\Struct\\CCODMax',
            'cParcelWeightsMax' => '\\GlsApi\\Struct\\CParcelWeightsMax',
            'cCountryCDXMaxArray' => '\\GlsApi\\Array\\CCountryCDXMaxArray',
            'cCountryCDXMax' => '\\GlsApi\\Struct\\CCountryCDXMax',
            'cCity' => '\\GlsApi\\Struct\\CCity',
            'cBooleanValue' => '\\GlsApi\\Struct\\CBooleanValue',
            'cValue' => '\\GlsApi\\Struct\\CValue',
            'cParcelShopArray' => '\\GlsApi\\Array\\CParcelShopArray',
            'cParcelShop' => '\\GlsApi\\Struct\\CParcelShop',
            'cParcelShop2Array' => '\\GlsApi\\Array\\CParcelShop2Array',
            'cParcelShop2' => '\\GlsApi\\Struct\\CParcelShop2',
            'cParcelShop2OpeningHoursArray' => '\\GlsApi\\Array\\CParcelShop2OpeningHoursArray',
            'cParcelShop2OpeningHours' => '\\GlsApi\\Struct\\CParcelShop2OpeningHours',
            'cParcelShop2HolidaysArray' => '\\GlsApi\\Array\\CParcelShop2HolidaysArray',
            'cParcelShop2Holidays' => '\\GlsApi\\Struct\\CParcelShop2Holidays',
            'cParcelShop2PaymentsArray' => '\\GlsApi\\Array\\CParcelShop2PaymentsArray',
            'cParcelShop2Payment' => '\\GlsApi\\Struct\\CParcelShop2Payment',
            'cParcelShop2GroupsArray' => '\\GlsApi\\Array\\CParcelShop2GroupsArray',
            'cParcelShop2Group' => '\\GlsApi\\Struct\\CParcelShop2Group',
            'cParcelShop2ServicesArray' => '\\GlsApi\\Array\\CParcelShop2ServicesArray',
            'cParcelShop2Service' => '\\GlsApi\\Struct\\CParcelShop2Service',
            'cParcelShop2ValidsArray' => '\\GlsApi\\Array\\CParcelShop2ValidsArray',
            'cParcelShop2Valid' => '\\GlsApi\\Struct\\CParcelShop2Valid',
            'cParcelShop2DescArray' => '\\GlsApi\\Array\\CParcelShop2DescArray',
            'cParcelShop2Desc' => '\\GlsApi\\Struct\\CParcelShop2Desc',
            'cParcelShop2InfoArray' => '\\GlsApi\\Array\\CParcelShop2InfoArray',
            'cParcelShop2Info' => '\\GlsApi\\Struct\\CParcelShop2Info',
            'cCustomsDecPdf' => '\\GlsApi\\Struct\\CCustomsDecPdf',
            'cPODsArray' => '\\GlsApi\\Array\\CPODsArray',
            'cPOD' => '\\GlsApi\\Struct\\CPOD',
            'cPodPdf' => '\\GlsApi\\Struct\\CPodPdf',
            'adeLogin' => '\\GlsApi\\Struct\\AdeLogin',
            'adeLoginResponse' => '\\GlsApi\\Struct\\AdeLoginResponse',
            'adeLoginIntegrator' => '\\GlsApi\\Struct\\AdeLoginIntegrator',
            'adeLoginIntegratorResponse' => '\\GlsApi\\Struct\\AdeLoginIntegratorResponse',
            'adeLoginByLocalizationCode' => '\\GlsApi\\Struct\\AdeLoginByLocalizationCode',
            'adeLoginByLocalizationCodeResponse' => '\\GlsApi\\Struct\\AdeLoginByLocalizationCodeResponse',
            'adeLogout' => '\\GlsApi\\Struct\\AdeLogout',
            'adeLogoutResponse' => '\\GlsApi\\Struct\\AdeLogoutResponse',
            'adePreparingBox_Insert' => '\\GlsApi\\Struct\\AdePreparingBox_Insert',
            'adePreparingBox_InsertResponse' => '\\GlsApi\\Struct\\AdePreparingBox_InsertResponse',
            'adePreparingBox_InsertExt' => '\\GlsApi\\Struct\\AdePreparingBox_InsertExt',
            'adePreparingBox_InsertExtResponse' => '\\GlsApi\\Struct\\AdePreparingBox_InsertExtResponse',
            'adePreparingBox_GetConsignIDs' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignIDs',
            'adePreparingBox_GetConsignIDsResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignIDsResponse',
            'adePreparingBox_DeleteConsign' => '\\GlsApi\\Struct\\AdePreparingBox_DeleteConsign',
            'adePreparingBox_DeleteConsignResponse' => '\\GlsApi\\Struct\\AdePreparingBox_DeleteConsignResponse',
            'adePreparingBox_GetConsign' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsign',
            'adePreparingBox_GetConsignResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignResponse',
            'adePreparingBox_GetConsignLabels' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignLabels',
            'adePreparingBox_GetConsignLabelsResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignLabelsResponse',
            'adePreparingBox_GetConsignLabelsExt' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignLabelsExt',
            'adePreparingBox_GetConsignLabelsExtResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignLabelsExtResponse',
            'adePreparingBox_GetConsignDocs' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignDocs',
            'adePreparingBox_GetConsignDocsResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignDocsResponse',
            'adePreparingBox_GetConsignsLabels' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignsLabels',
            'adePreparingBox_GetConsignsLabelsResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignsLabelsResponse',
            'adePreparingBox_GetParcelLabel' => '\\GlsApi\\Struct\\AdePreparingBox_GetParcelLabel',
            'adePreparingBox_GetParcelLabelResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetParcelLabelResponse',
            'adePickup_Create' => '\\GlsApi\\Struct\\AdePickup_Create',
            'adePickup_CreateResponse' => '\\GlsApi\\Struct\\AdePickup_CreateResponse',
            'adePickup_GetIDs' => '\\GlsApi\\Struct\\AdePickup_GetIDs',
            'adePickup_GetIDsResponse' => '\\GlsApi\\Struct\\AdePickup_GetIDsResponse',
            'adePickup_Get' => '\\GlsApi\\Struct\\AdePickup_Get',
            'adePickup_GetResponse' => '\\GlsApi\\Struct\\AdePickup_GetResponse',
            'adePickup_GetConsignBinds' => '\\GlsApi\\Struct\\AdePickup_GetConsignBinds',
            'adePickup_GetConsignBindsResponse' => '\\GlsApi\\Struct\\AdePickup_GetConsignBindsResponse',
            'adePickup_GetConsignIDs' => '\\GlsApi\\Struct\\AdePickup_GetConsignIDs',
            'adePickup_GetConsignIDsResponse' => '\\GlsApi\\Struct\\AdePickup_GetConsignIDsResponse',
            'adePickup_GetConsign' => '\\GlsApi\\Struct\\AdePickup_GetConsign',
            'adePickup_GetConsignResponse' => '\\GlsApi\\Struct\\AdePickup_GetConsignResponse',
            'adePickup_GetReceipt' => '\\GlsApi\\Struct\\AdePickup_GetReceipt',
            'adePickup_GetReceiptResponse' => '\\GlsApi\\Struct\\AdePickup_GetReceiptResponse',
            'adePickup_GetLabels' => '\\GlsApi\\Struct\\AdePickup_GetLabels',
            'adePickup_GetLabelsResponse' => '\\GlsApi\\Struct\\AdePickup_GetLabelsResponse',
            'adePickup_GetIdent' => '\\GlsApi\\Struct\\AdePickup_GetIdent',
            'adePickup_GetIdentResponse' => '\\GlsApi\\Struct\\AdePickup_GetIdentResponse',
            'adePickup_GetConsignLabels' => '\\GlsApi\\Struct\\AdePickup_GetConsignLabels',
            'adePickup_GetConsignLabelsResponse' => '\\GlsApi\\Struct\\AdePickup_GetConsignLabelsResponse',
            'adePickup_GetConsignLabelsExt' => '\\GlsApi\\Struct\\AdePickup_GetConsignLabelsExt',
            'adePickup_GetConsignLabelsExtResponse' => '\\GlsApi\\Struct\\AdePickup_GetConsignLabelsExtResponse',
            'adePickup_GetParcelLabel' => '\\GlsApi\\Struct\\AdePickup_GetParcelLabel',
            'adePickup_GetParcelLabelResponse' => '\\GlsApi\\Struct\\AdePickup_GetParcelLabelResponse',
            'adePickup_GetParcelsLabels' => '\\GlsApi\\Struct\\AdePickup_GetParcelsLabels',
            'adePickup_GetParcelsLabelsResponse' => '\\GlsApi\\Struct\\AdePickup_GetParcelsLabelsResponse',
            'adePickup_ParcelNumberSearch' => '\\GlsApi\\Struct\\AdePickup_ParcelNumberSearch',
            'adePickup_ParcelNumberSearchResponse' => '\\GlsApi\\Struct\\AdePickup_ParcelNumberSearchResponse',
            'adePartner_GetParcelNumber' => '\\GlsApi\\Struct\\AdePartner_GetParcelNumber',
            'adePartner_GetParcelNumberResponse' => '\\GlsApi\\Struct\\AdePartner_GetParcelNumberResponse',
            'adeTrackID_Get' => '\\GlsApi\\Struct\\AdeTrackID_Get',
            'adeTrackID_GetResponse' => '\\GlsApi\\Struct\\AdeTrackID_GetResponse',
            'adeProfile_GetIDs' => '\\GlsApi\\Struct\\AdeProfile_GetIDs',
            'adeProfile_GetIDsResponse' => '\\GlsApi\\Struct\\AdeProfile_GetIDsResponse',
            'adeProfile_GetActive' => '\\GlsApi\\Struct\\AdeProfile_GetActive',
            'adeProfile_GetActiveResponse' => '\\GlsApi\\Struct\\AdeProfile_GetActiveResponse',
            'adeProfile_Change' => '\\GlsApi\\Struct\\AdeProfile_Change',
            'adeProfile_ChangeResponse' => '\\GlsApi\\Struct\\AdeProfile_ChangeResponse',
            'adeLang_GetActive' => '\\GlsApi\\Struct\\AdeLang_GetActive',
            'adeLang_GetActiveResponse' => '\\GlsApi\\Struct\\AdeLang_GetActiveResponse',
            'adeLang_Change' => '\\GlsApi\\Struct\\AdeLang_Change',
            'adeLang_ChangeResponse' => '\\GlsApi\\Struct\\AdeLang_ChangeResponse',
            'adePfc_GetStatus' => '\\GlsApi\\Struct\\AdePfc_GetStatus',
            'adePfc_GetStatusResponse' => '\\GlsApi\\Struct\\AdePfc_GetStatusResponse',
            'adePfc_GetDictionary' => '\\GlsApi\\Struct\\AdePfc_GetDictionary',
            'adePfc_GetDictionaryResponse' => '\\GlsApi\\Struct\\AdePfc_GetDictionaryResponse',
            'adeSendAddr_GetStatus' => '\\GlsApi\\Struct\\AdeSendAddr_GetStatus',
            'adeSendAddr_GetStatusResponse' => '\\GlsApi\\Struct\\AdeSendAddr_GetStatusResponse',
            'adeSendAddr_GetDictionary' => '\\GlsApi\\Struct\\AdeSendAddr_GetDictionary',
            'adeSendAddr_GetDictionaryResponse' => '\\GlsApi\\Struct\\AdeSendAddr_GetDictionaryResponse',
            'adeServices_GetAllowed' => '\\GlsApi\\Struct\\AdeServices_GetAllowed',
            'adeServices_GetAllowedResponse' => '\\GlsApi\\Struct\\AdeServices_GetAllowedResponse',
            'adeServices_GetMaxCOD' => '\\GlsApi\\Struct\\AdeServices_GetMaxCOD',
            'adeServices_GetMaxCODResponse' => '\\GlsApi\\Struct\\AdeServices_GetMaxCODResponse',
            'adeServices_GetMaxParcelWeights' => '\\GlsApi\\Struct\\AdeServices_GetMaxParcelWeights',
            'adeServices_GetMaxParcelWeightsResponse' => '\\GlsApi\\Struct\\AdeServices_GetMaxParcelWeightsResponse',
            'adeServices_GetGuaranteed' => '\\GlsApi\\Struct\\AdeServices_GetGuaranteed',
            'adeServices_GetGuaranteedResponse' => '\\GlsApi\\Struct\\AdeServices_GetGuaranteedResponse',
            'adeServices_GetCountriesSDS' => '\\GlsApi\\Struct\\AdeServices_GetCountriesSDS',
            'adeServices_GetCountriesSDSResponse' => '\\GlsApi\\Struct\\AdeServices_GetCountriesSDSResponse',
            'adeServices_GetCountriesSRS' => '\\GlsApi\\Struct\\AdeServices_GetCountriesSRS',
            'adeServices_GetCountriesSRSResponse' => '\\GlsApi\\Struct\\AdeServices_GetCountriesSRSResponse',
            'adeServices_GetCountriesCDX' => '\\GlsApi\\Struct\\AdeServices_GetCountriesCDX',
            'adeServices_GetCountriesCDXResponse' => '\\GlsApi\\Struct\\AdeServices_GetCountriesCDXResponse',
            'adeZip_GetCity' => '\\GlsApi\\Struct\\AdeZip_GetCity',
            'adeZip_GetCityResponse' => '\\GlsApi\\Struct\\AdeZip_GetCityResponse',
            'adeZip_CustomsRequired' => '\\GlsApi\\Struct\\AdeZip_CustomsRequired',
            'adeZip_CustomsRequiredResponse' => '\\GlsApi\\Struct\\AdeZip_CustomsRequiredResponse',
            'adeOption_Get' => '\\GlsApi\\Struct\\AdeOption_Get',
            'adeOption_GetResponse' => '\\GlsApi\\Struct\\AdeOption_GetResponse',
            'adeOption_Set' => '\\GlsApi\\Struct\\AdeOption_Set',
            'adeOption_SetResponse' => '\\GlsApi\\Struct\\AdeOption_SetResponse',
            'adeParcelShop_SearchByZip' => '\\GlsApi\\Struct\\AdeParcelShop_SearchByZip',
            'adeParcelShop_SearchByZipResponse' => '\\GlsApi\\Struct\\AdeParcelShop_SearchByZipResponse',
            'adeParcelShop_SearchByID' => '\\GlsApi\\Struct\\AdeParcelShop_SearchByID',
            'adeParcelShop_SearchByIDResponse' => '\\GlsApi\\Struct\\AdeParcelShop_SearchByIDResponse',
            'adeParcelShop_GetByCountry' => '\\GlsApi\\Struct\\AdeParcelShop_GetByCountry',
            'adeParcelShop_GetByCountryResponse' => '\\GlsApi\\Struct\\AdeParcelShop_GetByCountryResponse',
            'adeParcelShop2_GetByCountry' => '\\GlsApi\\Struct\\AdeParcelShop2_GetByCountry',
            'adeParcelShop2_GetByCountryResponse' => '\\GlsApi\\Struct\\AdeParcelShop2_GetByCountryResponse',
            'adeParcelShop2_SearchByZip' => '\\GlsApi\\Struct\\AdeParcelShop2_SearchByZip',
            'adeParcelShop2_SearchByZipResponse' => '\\GlsApi\\Struct\\AdeParcelShop2_SearchByZipResponse',
            'adePreparingBox_GetConsignCustomsDec' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignCustomsDec',
            'adePreparingBox_GetConsignCustomsDecResponse' => '\\GlsApi\\Struct\\AdePreparingBox_GetConsignCustomsDecResponse',
            'adePickup_GetConsignCustomsDec' => '\\GlsApi\\Struct\\AdePickup_GetConsignCustomsDec',
            'adePickup_GetConsignCustomsDecResponse' => '\\GlsApi\\Struct\\AdePickup_GetConsignCustomsDecResponse',
            'adePickup_GetConsignPODs' => '\\GlsApi\\Struct\\AdePickup_GetConsignPODs',
            'adePickup_GetConsignPODsResponse' => '\\GlsApi\\Struct\\AdePickup_GetConsignPODsResponse',
            'adePOD_Get' => '\\GlsApi\\Struct\\AdePOD_Get',
            'adePOD_GetResponse' => '\\GlsApi\\Struct\\AdePOD_GetResponse',
            'adeCourier_Order' => '\\GlsApi\\Struct\\AdeCourier_Order',
            'adeCourier_OrderResponse' => '\\GlsApi\\Struct\\AdeCourier_OrderResponse',
        );
    }
}
