<?php

namespace GlsApi\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cProfilesArray Array
 * @subpackage Arrays
 */
class CProfilesArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \GlsApi\Struct\CProfile[]
     */
    public $items;
    /**
     * Constructor method for cProfilesArray
     * @uses CProfilesArray::setItems()
     * @param \GlsApi\Struct\CProfile[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \GlsApi\Struct\CProfile[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cProfilesArrayItemsItem) {
            // validation for constraint: itemType
            if (!$cProfilesArrayItemsItem instanceof \GlsApi\Struct\CProfile) {
                $invalidValues[] = is_object($cProfilesArrayItemsItem) ? get_class($cProfilesArrayItemsItem) : sprintf('%s(%s)', gettype($cProfilesArrayItemsItem), var_export($cProfilesArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \GlsApi\Struct\CProfile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\CProfile[] $items
     * @return \GlsApi\Array\CProfilesArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\CProfile $item
     * @return \GlsApi\Array\CProfilesArray
     */
    public function addToItems(\GlsApi\Struct\CProfile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\Struct\CProfile) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \GlsApi\Struct\CProfile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GlsApi\Struct\CProfile
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GlsApi\Struct\CProfile
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GlsApi\Struct\CProfile
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GlsApi\Struct\CProfile
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GlsApi\Struct\CProfile
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
