<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cParcelWeightsMax Struct
 * @subpackage Structs
 */
class CParcelWeightsMax extends AbstractStructBase
{
    /**
     * The weight_max_national
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight_max_national;
    /**
     * The weight_max_international
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight_max_international;
    /**
     * Constructor method for cParcelWeightsMax
     * @uses CParcelWeightsMax::setWeight_max_national()
     * @uses CParcelWeightsMax::setWeight_max_international()
     * @param float $weight_max_national
     * @param float $weight_max_international
     */
    public function __construct($weight_max_national = null, $weight_max_international = null)
    {
        $this
            ->setWeight_max_national($weight_max_national)
            ->setWeight_max_international($weight_max_international);
    }
    /**
     * Get weight_max_national value
     * @return float
     */
    public function getWeight_max_national()
    {
        return $this->weight_max_national;
    }
    /**
     * Set weight_max_national value
     * @param float $weight_max_national
     * @return \GlsApi\Struct\CParcelWeightsMax
     */
    public function setWeight_max_national($weight_max_national = null)
    {
        // validation for constraint: float
        if (!is_null($weight_max_national) && !(is_float($weight_max_national) || is_numeric($weight_max_national))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight_max_national, true), gettype($weight_max_national)), __LINE__);
        }
        $this->weight_max_national = $weight_max_national;
        return $this;
    }
    /**
     * Get weight_max_international value
     * @return float
     */
    public function getWeight_max_international()
    {
        return $this->weight_max_international;
    }
    /**
     * Set weight_max_international value
     * @param float $weight_max_international
     * @return \GlsApi\Struct\CParcelWeightsMax
     */
    public function setWeight_max_international($weight_max_international = null)
    {
        // validation for constraint: float
        if (!is_null($weight_max_international) && !(is_float($weight_max_international) || is_numeric($weight_max_international))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight_max_international, true), gettype($weight_max_international)), __LINE__);
        }
        $this->weight_max_international = $weight_max_international;
        return $this;
    }
}
