<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cParcel Struct
 * @subpackage Structs
 */
class CParcel extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The srv_ade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $srv_ade;
    /**
     * The srv_bool
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsApi\Struct\CServicesBool
     */
    public $srv_bool;
    /**
     * Constructor method for cParcel
     * @uses CParcel::setNumber()
     * @uses CParcel::setReference()
     * @uses CParcel::setWeight()
     * @uses CParcel::setSrv_ade()
     * @uses CParcel::setSrv_bool()
     * @param string $number
     * @param string $reference
     * @param float $weight
     * @param string $srv_ade
     * @param \GlsApi\Struct\CServicesBool $srv_bool
     */
    public function __construct($number = null, $reference = null, $weight = null, $srv_ade = null, \GlsApi\Struct\CServicesBool $srv_bool = null)
    {
        $this
            ->setNumber($number)
            ->setReference($reference)
            ->setWeight($weight)
            ->setSrv_ade($srv_ade)
            ->setSrv_bool($srv_bool);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \GlsApi\Struct\CParcel
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \GlsApi\Struct\CParcel
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \GlsApi\Struct\CParcel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get srv_ade value
     * @return string|null
     */
    public function getSrv_ade()
    {
        return $this->srv_ade;
    }
    /**
     * Set srv_ade value
     * @param string $srv_ade
     * @return \GlsApi\Struct\CParcel
     */
    public function setSrv_ade($srv_ade = null)
    {
        // validation for constraint: string
        if (!is_null($srv_ade) && !is_string($srv_ade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srv_ade, true), gettype($srv_ade)), __LINE__);
        }
        $this->srv_ade = $srv_ade;
        return $this;
    }
    /**
     * Get srv_bool value
     * @return \GlsApi\Struct\CServicesBool|null
     */
    public function getSrv_bool()
    {
        return $this->srv_bool;
    }
    /**
     * Set srv_bool value
     * @param \GlsApi\Struct\CServicesBool $srv_bool
     * @return \GlsApi\Struct\CParcel
     */
    public function setSrv_bool(\GlsApi\Struct\CServicesBool $srv_bool = null)
    {
        $this->srv_bool = $srv_bool;
        return $this;
    }
}
