<?php

namespace GlsApi\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cCountryCDXMaxArray Array
 * @subpackage Arrays
 */
class CCountryCDXMaxArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \GlsApi\Struct\CCountryCDXMax[]
     */
    public $items;
    /**
     * Constructor method for cCountryCDXMaxArray
     * @uses CCountryCDXMaxArray::setItems()
     * @param \GlsApi\Struct\CCountryCDXMax[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \GlsApi\Struct\CCountryCDXMax[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cCountryCDXMaxArrayItemsItem) {
            // validation for constraint: itemType
            if (!$cCountryCDXMaxArrayItemsItem instanceof \GlsApi\Struct\CCountryCDXMax) {
                $invalidValues[] = is_object($cCountryCDXMaxArrayItemsItem) ? get_class($cCountryCDXMaxArrayItemsItem) : sprintf('%s(%s)', gettype($cCountryCDXMaxArrayItemsItem), var_export($cCountryCDXMaxArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \GlsApi\Struct\CCountryCDXMax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\CCountryCDXMax[] $items
     * @return \GlsApi\Array\CCountryCDXMaxArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\CCountryCDXMax $item
     * @return \GlsApi\Array\CCountryCDXMaxArray
     */
    public function addToItems(\GlsApi\Struct\CCountryCDXMax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\Struct\CCountryCDXMax) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \GlsApi\Struct\CCountryCDXMax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GlsApi\Struct\CCountryCDXMax
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GlsApi\Struct\CCountryCDXMax
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GlsApi\Struct\CCountryCDXMax
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GlsApi\Struct\CCountryCDXMax
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GlsApi\Struct\CCountryCDXMax
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
