<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ade-test.gls-poland.com/adeplus/pm1/ade_webapi2.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ade-test.gls-poland.com/adeplus/pm1/ade_webapi2.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \GlsApi\ClassMap::get(),
);
/**
 * Samples for Ade ServiceType
 */
$ade = new \GlsApi\Service\Ade($options);
/**
 * Sample call for adeLogin operation/method
 */
if ($ade->adeLogin(new \GlsApi\Struct\AdeLogin()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLoginIntegrator operation/method
 */
if ($ade->adeLoginIntegrator(new \GlsApi\Struct\AdeLoginIntegrator()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLoginByLocalizationCode operation/method
 */
if ($ade->adeLoginByLocalizationCode(new \GlsApi\Struct\AdeLoginByLocalizationCode()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLogout operation/method
 */
if ($ade->adeLogout(new \GlsApi\Struct\AdeLogout()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_Insert operation/method
 */
if ($ade->adePreparingBox_Insert(new \GlsApi\Struct\AdePreparingBox_Insert()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_InsertExt operation/method
 */
if ($ade->adePreparingBox_InsertExt(new \GlsApi\Struct\AdePreparingBox_InsertExt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignIDs operation/method
 */
if ($ade->adePreparingBox_GetConsignIDs(new \GlsApi\Struct\AdePreparingBox_GetConsignIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_DeleteConsign operation/method
 */
if ($ade->adePreparingBox_DeleteConsign(new \GlsApi\Struct\AdePreparingBox_DeleteConsign()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsign operation/method
 */
if ($ade->adePreparingBox_GetConsign(new \GlsApi\Struct\AdePreparingBox_GetConsign()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignLabels operation/method
 */
if ($ade->adePreparingBox_GetConsignLabels(new \GlsApi\Struct\AdePreparingBox_GetConsignLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignLabelsExt operation/method
 */
if ($ade->adePreparingBox_GetConsignLabelsExt(new \GlsApi\Struct\AdePreparingBox_GetConsignLabelsExt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignDocs operation/method
 */
if ($ade->adePreparingBox_GetConsignDocs(new \GlsApi\Struct\AdePreparingBox_GetConsignDocs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignsLabels operation/method
 */
if ($ade->adePreparingBox_GetConsignsLabels(new \GlsApi\Struct\AdePreparingBox_GetConsignsLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetParcelLabel operation/method
 */
if ($ade->adePreparingBox_GetParcelLabel(new \GlsApi\Struct\AdePreparingBox_GetParcelLabel()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_Create operation/method
 */
if ($ade->adePickup_Create(new \GlsApi\Struct\AdePickup_Create()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetIDs operation/method
 */
if ($ade->adePickup_GetIDs(new \GlsApi\Struct\AdePickup_GetIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_Get operation/method
 */
if ($ade->adePickup_Get(new \GlsApi\Struct\AdePickup_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignBinds operation/method
 */
if ($ade->adePickup_GetConsignBinds(new \GlsApi\Struct\AdePickup_GetConsignBinds()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignIDs operation/method
 */
if ($ade->adePickup_GetConsignIDs(new \GlsApi\Struct\AdePickup_GetConsignIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsign operation/method
 */
if ($ade->adePickup_GetConsign(new \GlsApi\Struct\AdePickup_GetConsign()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetReceipt operation/method
 */
if ($ade->adePickup_GetReceipt(new \GlsApi\Struct\AdePickup_GetReceipt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetLabels operation/method
 */
if ($ade->adePickup_GetLabels(new \GlsApi\Struct\AdePickup_GetLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetIdent operation/method
 */
if ($ade->adePickup_GetIdent(new \GlsApi\Struct\AdePickup_GetIdent()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignLabels operation/method
 */
if ($ade->adePickup_GetConsignLabels(new \GlsApi\Struct\AdePickup_GetConsignLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignLabelsExt operation/method
 */
if ($ade->adePickup_GetConsignLabelsExt(new \GlsApi\Struct\AdePickup_GetConsignLabelsExt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetParcelLabel operation/method
 */
if ($ade->adePickup_GetParcelLabel(new \GlsApi\Struct\AdePickup_GetParcelLabel()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetParcelsLabels operation/method
 */
if ($ade->adePickup_GetParcelsLabels(new \GlsApi\Struct\AdePickup_GetParcelsLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_ParcelNumberSearch operation/method
 */
if ($ade->adePickup_ParcelNumberSearch(new \GlsApi\Struct\AdePickup_ParcelNumberSearch()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePartner_GetParcelNumber operation/method
 */
if ($ade->adePartner_GetParcelNumber(new \GlsApi\Struct\AdePartner_GetParcelNumber()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeTrackID_Get operation/method
 */
if ($ade->adeTrackID_Get(new \GlsApi\Struct\AdeTrackID_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeProfile_GetIDs operation/method
 */
if ($ade->adeProfile_GetIDs(new \GlsApi\Struct\AdeProfile_GetIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeProfile_GetActive operation/method
 */
if ($ade->adeProfile_GetActive(new \GlsApi\Struct\AdeProfile_GetActive()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeProfile_Change operation/method
 */
if ($ade->adeProfile_Change(new \GlsApi\Struct\AdeProfile_Change()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLang_GetActive operation/method
 */
if ($ade->adeLang_GetActive(new \GlsApi\Struct\AdeLang_GetActive()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLang_Change operation/method
 */
if ($ade->adeLang_Change(new \GlsApi\Struct\AdeLang_Change()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePfc_GetStatus operation/method
 */
if ($ade->adePfc_GetStatus(new \GlsApi\Struct\AdePfc_GetStatus()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePfc_GetDictionary operation/method
 */
if ($ade->adePfc_GetDictionary(new \GlsApi\Struct\AdePfc_GetDictionary()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeSendAddr_GetStatus operation/method
 */
if ($ade->adeSendAddr_GetStatus(new \GlsApi\Struct\AdeSendAddr_GetStatus()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeSendAddr_GetDictionary operation/method
 */
if ($ade->adeSendAddr_GetDictionary(new \GlsApi\Struct\AdeSendAddr_GetDictionary()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetAllowed operation/method
 */
if ($ade->adeServices_GetAllowed(new \GlsApi\Struct\AdeServices_GetAllowed()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetMaxCOD operation/method
 */
if ($ade->adeServices_GetMaxCOD(new \GlsApi\Struct\AdeServices_GetMaxCOD()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetMaxParcelWeights operation/method
 */
if ($ade->adeServices_GetMaxParcelWeights(new \GlsApi\Struct\AdeServices_GetMaxParcelWeights()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetGuaranteed operation/method
 */
if ($ade->adeServices_GetGuaranteed(new \GlsApi\Struct\AdeServices_GetGuaranteed()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetCountriesSDS operation/method
 */
if ($ade->adeServices_GetCountriesSDS(new \GlsApi\Struct\AdeServices_GetCountriesSDS()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetCountriesSRS operation/method
 */
if ($ade->adeServices_GetCountriesSRS(new \GlsApi\Struct\AdeServices_GetCountriesSRS()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetCountriesCDX operation/method
 */
if ($ade->adeServices_GetCountriesCDX(new \GlsApi\Struct\AdeServices_GetCountriesCDX()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeZip_GetCity operation/method
 */
if ($ade->adeZip_GetCity(new \GlsApi\Struct\AdeZip_GetCity()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeZip_CustomsRequired operation/method
 */
if ($ade->adeZip_CustomsRequired(new \GlsApi\Struct\AdeZip_CustomsRequired()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeOption_Get operation/method
 */
if ($ade->adeOption_Get(new \GlsApi\Struct\AdeOption_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeOption_Set operation/method
 */
if ($ade->adeOption_Set(new \GlsApi\Struct\AdeOption_Set()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop_SearchByZip operation/method
 */
if ($ade->adeParcelShop_SearchByZip(new \GlsApi\Struct\AdeParcelShop_SearchByZip()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop_SearchByID operation/method
 */
if ($ade->adeParcelShop_SearchByID(new \GlsApi\Struct\AdeParcelShop_SearchByID()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop_GetByCountry operation/method
 */
if ($ade->adeParcelShop_GetByCountry(new \GlsApi\Struct\AdeParcelShop_GetByCountry()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop2_GetByCountry operation/method
 */
if ($ade->adeParcelShop2_GetByCountry(new \GlsApi\Struct\AdeParcelShop2_GetByCountry()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop2_SearchByZip operation/method
 */
if ($ade->adeParcelShop2_SearchByZip(new \GlsApi\Struct\AdeParcelShop2_SearchByZip()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignCustomsDec operation/method
 */
if ($ade->adePreparingBox_GetConsignCustomsDec(new \GlsApi\Struct\AdePreparingBox_GetConsignCustomsDec()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignCustomsDec operation/method
 */
if ($ade->adePickup_GetConsignCustomsDec(new \GlsApi\Struct\AdePickup_GetConsignCustomsDec()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignPODs operation/method
 */
if ($ade->adePickup_GetConsignPODs(new \GlsApi\Struct\AdePickup_GetConsignPODs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePOD_Get operation/method
 */
if ($ade->adePOD_Get(new \GlsApi\Struct\AdePOD_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeCourier_Order operation/method
 */
if ($ade->adeCourier_Order(new \GlsApi\Struct\AdeCourier_Order()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
