<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cPartnerParcelNumber Struct
 * @subpackage Structs
 */
class CPartnerParcelNumber extends AbstractStructBase
{
    /**
     * The partner_number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $partner_number;
    /**
     * Constructor method for cPartnerParcelNumber
     * @uses CPartnerParcelNumber::setPartner_number()
     * @param string $partner_number
     */
    public function __construct($partner_number = null)
    {
        $this
            ->setPartner_number($partner_number);
    }
    /**
     * Get partner_number value
     * @return string
     */
    public function getPartner_number()
    {
        return $this->partner_number;
    }
    /**
     * Set partner_number value
     * @param string $partner_number
     * @return \GlsApi\Struct\CPartnerParcelNumber
     */
    public function setPartner_number($partner_number = null)
    {
        // validation for constraint: string
        if (!is_null($partner_number) && !is_string($partner_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner_number, true), gettype($partner_number)), __LINE__);
        }
        $this->partner_number = $partner_number;
        return $this;
    }
}
