<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adeParcelShop_SearchByZip Struct
 * Meta information extracted from the WSDL
 * - type: tns:adeParcelShop_SearchByZip
 * @subpackage Structs
 */
class AdeParcelShop_SearchByZip extends AbstractStructBase
{
    /**
     * The session
     * @var string
     */
    public $session;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The zipcode
     * @var string
     */
    public $zipcode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * Constructor method for adeParcelShop_SearchByZip
     * @uses AdeParcelShop_SearchByZip::setSession()
     * @uses AdeParcelShop_SearchByZip::setCountry()
     * @uses AdeParcelShop_SearchByZip::setZipcode()
     * @uses AdeParcelShop_SearchByZip::setStreet()
     * @param string $session
     * @param string $country
     * @param string $zipcode
     * @param string $street
     */
    public function __construct($session = null, $country = null, $zipcode = null, $street = null)
    {
        $this
            ->setSession($session)
            ->setCountry($country)
            ->setZipcode($zipcode)
            ->setStreet($street);
    }
    /**
     * Get session value
     * @return string|null
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param string $session
     * @return \GlsApi\Struct\AdeParcelShop_SearchByZip
     */
    public function setSession($session = null)
    {
        // validation for constraint: string
        if (!is_null($session) && !is_string($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($session, true), gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \GlsApi\Struct\AdeParcelShop_SearchByZip
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->zipcode;
    }
    /**
     * Set zipcode value
     * @param string $zipcode
     * @return \GlsApi\Struct\AdeParcelShop_SearchByZip
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        $this->zipcode = $zipcode;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \GlsApi\Struct\AdeParcelShop_SearchByZip
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
}
