<?php

namespace GlsApi\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cLabelsArray Array
 * @subpackage Arrays
 */
class CLabelsArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \GlsApi\Struct\CLabel[]
     */
    public $items;
    /**
     * Constructor method for cLabelsArray
     * @uses CLabelsArray::setItems()
     * @param \GlsApi\Struct\CLabel[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \GlsApi\Struct\CLabel[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cLabelsArrayItemsItem) {
            // validation for constraint: itemType
            if (!$cLabelsArrayItemsItem instanceof \GlsApi\Struct\CLabel) {
                $invalidValues[] = is_object($cLabelsArrayItemsItem) ? get_class($cLabelsArrayItemsItem) : sprintf('%s(%s)', gettype($cLabelsArrayItemsItem), var_export($cLabelsArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \GlsApi\Struct\CLabel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\CLabel[] $items
     * @return \GlsApi\Array\CLabelsArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\CLabel $item
     * @return \GlsApi\Array\CLabelsArray
     */
    public function addToItems(\GlsApi\Struct\CLabel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\Struct\CLabel) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \GlsApi\Struct\CLabel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GlsApi\Struct\CLabel
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GlsApi\Struct\CLabel
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GlsApi\Struct\CLabel
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GlsApi\Struct\CLabel
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GlsApi\Struct\CLabel
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
