<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wyszukiwarkaregontest.stat.gov.pl/wsBIR/wsdl/UslugaBIRzewnPubl-ver11-test.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wyszukiwarkaregontest.stat.gov.pl/wsBIR/wsdl/UslugaBIRzewnPubl-ver11-test.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetValue operation/method
 */
if ($get->GetValue(new \StructType\GetValue()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Zaloguj ServiceType
 */
$zaloguj = new \ServiceType\Zaloguj($options);
/**
 * Sample call for Zaloguj operation/method
 */
if ($zaloguj->Zaloguj(new \StructType\Zaloguj()) !== false) {
    print_r($zaloguj->getResult());
} else {
    print_r($zaloguj->getLastError());
}
/**
 * Samples for Wyloguj ServiceType
 */
$wyloguj = new \ServiceType\Wyloguj($options);
/**
 * Sample call for Wyloguj operation/method
 */
if ($wyloguj->Wyloguj(new \StructType\Wyloguj()) !== false) {
    print_r($wyloguj->getResult());
} else {
    print_r($wyloguj->getLastError());
}
/**
 * Samples for Dane ServiceType
 */
$dane = new \ServiceType\Dane($options);
/**
 * Sample call for DaneSzukajPodmioty operation/method
 */
if ($dane->DaneSzukajPodmioty(new \StructType\DaneSzukajPodmioty()) !== false) {
    print_r($dane->getResult());
} else {
    print_r($dane->getLastError());
}
/**
 * Sample call for DanePobierzPelnyRaport operation/method
 */
if ($dane->DanePobierzPelnyRaport(new \StructType\DanePobierzPelnyRaport()) !== false) {
    print_r($dane->getResult());
} else {
    print_r($dane->getLastError());
}
/**
 * Sample call for DanePobierzRaportZbiorczy operation/method
 */
if ($dane->DanePobierzRaportZbiorczy(new \StructType\DanePobierzRaportZbiorczy()) !== false) {
    print_r($dane->getResult());
} else {
    print_r($dane->getLastError());
}
