<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dane ServiceType
 * @subpackage Services
 */
class Dane extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DaneSzukajPodmioty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DaneSzukajPodmioty $parameters
     * @return \StructType\DaneSzukajPodmiotyResponse|bool
     */
    public function DaneSzukajPodmioty(\StructType\DaneSzukajPodmioty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DaneSzukajPodmioty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DanePobierzPelnyRaport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DanePobierzPelnyRaport $parameters
     * @return \StructType\DanePobierzPelnyRaportResponse|bool
     */
    public function DanePobierzPelnyRaport(\StructType\DanePobierzPelnyRaport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DanePobierzPelnyRaport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DanePobierzRaportZbiorczy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DanePobierzRaportZbiorczy $parameters
     * @return \StructType\DanePobierzRaportZbiorczyResponse|bool
     */
    public function DanePobierzRaportZbiorczy(\StructType\DanePobierzRaportZbiorczy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DanePobierzRaportZbiorczy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DanePobierzPelnyRaportResponse|\StructType\DanePobierzRaportZbiorczyResponse|\StructType\DaneSzukajPodmiotyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
