<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestGetGroupDataByUserid StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestGetGroupDataByUserid
 * @subpackage Structs
 */
class RequestGetGroupDataByUserid extends TransactionInfo
{
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The ActiveOnly
     * @var int
     */
    public $ActiveOnly;
    /**
     * Constructor method for RequestGetGroupDataByUserid
     * @uses RequestGetGroupDataByUserid::setUserId()
     * @uses RequestGetGroupDataByUserid::setActiveOnly()
     * @param string $userId
     * @param int $activeOnly
     */
    public function __construct($userId = null, $activeOnly = null)
    {
        $this
            ->setUserId($userId)
            ->setActiveOnly($activeOnly);
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\RequestGetGroupDataByUserid
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get ActiveOnly value
     * @return int|null
     */
    public function getActiveOnly()
    {
        return $this->ActiveOnly;
    }
    /**
     * Set ActiveOnly value
     * @param int $activeOnly
     * @return \StructType\RequestGetGroupDataByUserid
     */
    public function setActiveOnly($activeOnly = null)
    {
        // validation for constraint: int
        if (!is_null($activeOnly) && !(is_int($activeOnly) || ctype_digit($activeOnly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activeOnly, true), gettype($activeOnly)), __LINE__);
        }
        $this->ActiveOnly = $activeOnly;
        return $this;
    }
}
