<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSecurityToken StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSecurityToken
 * @subpackage Structs
 */
class RetrieveSecurityToken extends CarrierInfo
{
    /**
     * The RetrieveSecurityTokenRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveSecurityToken
     */
    public $RetrieveSecurityTokenRequest;
    /**
     * The LogonID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogonID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * Constructor method for RetrieveSecurityToken
     * @uses RetrieveSecurityToken::setRetrieveSecurityTokenRequest()
     * @uses RetrieveSecurityToken::setLogonID()
     * @uses RetrieveSecurityToken::setPassword()
     * @param \StructType\RetrieveSecurityToken $retrieveSecurityTokenRequest
     * @param string $logonID
     * @param string $password
     */
    public function __construct(\StructType\RetrieveSecurityToken $retrieveSecurityTokenRequest = null, $logonID = null, $password = null)
    {
        $this
            ->setRetrieveSecurityTokenRequest($retrieveSecurityTokenRequest)
            ->setLogonID($logonID)
            ->setPassword($password);
    }
    /**
     * Get RetrieveSecurityTokenRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveSecurityToken|null
     */
    public function getRetrieveSecurityTokenRequest()
    {
        return isset($this->RetrieveSecurityTokenRequest) ? $this->RetrieveSecurityTokenRequest : null;
    }
    /**
     * Set RetrieveSecurityTokenRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveSecurityToken $retrieveSecurityTokenRequest
     * @return \StructType\RetrieveSecurityToken
     */
    public function setRetrieveSecurityTokenRequest(\StructType\RetrieveSecurityToken $retrieveSecurityTokenRequest = null)
    {
        if (is_null($retrieveSecurityTokenRequest) || (is_array($retrieveSecurityTokenRequest) && empty($retrieveSecurityTokenRequest))) {
            unset($this->RetrieveSecurityTokenRequest);
        } else {
            $this->RetrieveSecurityTokenRequest = $retrieveSecurityTokenRequest;
        }
        return $this;
    }
    /**
     * Get LogonID value
     * @return string|null
     */
    public function getLogonID()
    {
        return $this->LogonID;
    }
    /**
     * Set LogonID value
     * @param string $logonID
     * @return \StructType\RetrieveSecurityToken
     */
    public function setLogonID($logonID = null)
    {
        // validation for constraint: string
        if (!is_null($logonID) && !is_string($logonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logonID, true), gettype($logonID)), __LINE__);
        }
        $this->LogonID = $logonID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\RetrieveSecurityToken
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
