<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceType
 * @subpackage Services
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidateSecurityToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ValidateSecurityToken $parameters
     * @return \StructType\ValidateSecurityTokenResponse|bool
     */
    public function ValidateSecurityToken(\StructType\ValidateSecurityToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateSecurityToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ValidateSecurityTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
