<?php

namespace Scraper\ScraperColisPrive\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPickupPointsListReturn StructType
 * @subpackage Structs
 */
class GetPickupPointsListReturn extends AbstractStructBase
{
    /**
     * The WSResp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperColisPrive\StructType\ResponseObject
     */
    public $WSResp;
    /**
     * The PcksList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject[]
     */
    public $PcksList;
    /**
     * Constructor method for GetPickupPointsListReturn
     * @uses GetPickupPointsListReturn::setWSResp()
     * @uses GetPickupPointsListReturn::setPcksList()
     * @param \Scraper\ScraperColisPrive\StructType\ResponseObject $wSResp
     * @param \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject[] $pcksList
     */
    public function __construct(\Scraper\ScraperColisPrive\StructType\ResponseObject $wSResp = null, array $pcksList = array())
    {
        $this
            ->setWSResp($wSResp)
            ->setPcksList($pcksList);
    }
    /**
     * Get WSResp value
     * @return \Scraper\ScraperColisPrive\StructType\ResponseObject|null
     */
    public function getWSResp()
    {
        return $this->WSResp;
    }
    /**
     * Set WSResp value
     * @param \Scraper\ScraperColisPrive\StructType\ResponseObject $wSResp
     * @return \Scraper\ScraperColisPrive\StructType\GetPickupPointsListReturn
     */
    public function setWSResp(\Scraper\ScraperColisPrive\StructType\ResponseObject $wSResp = null)
    {
        $this->WSResp = $wSResp;
        return $this;
    }
    /**
     * Get PcksList value
     * @return \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject[]|null
     */
    public function getPcksList()
    {
        return $this->PcksList;
    }
    /**
     * This method is responsible for validating the values passed to the setPcksList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPcksList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePcksListForArrayConstraintsFromSetPcksList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPickupPointsListReturnPcksListItem) {
            // validation for constraint: itemType
            if (!$getPickupPointsListReturnPcksListItem instanceof \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject) {
                $invalidValues[] = is_object($getPickupPointsListReturnPcksListItem) ? get_class($getPickupPointsListReturnPcksListItem) : sprintf('%s(%s)', gettype($getPickupPointsListReturnPcksListItem), var_export($getPickupPointsListReturnPcksListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PcksList property can only contain items of type \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PcksList value
     * @throws \InvalidArgumentException
     * @param \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject[] $pcksList
     * @return \Scraper\ScraperColisPrive\StructType\GetPickupPointsListReturn
     */
    public function setPcksList(array $pcksList = array())
    {
        // validation for constraint: array
        if ('' !== ($pcksListArrayErrorMessage = self::validatePcksListForArrayConstraintsFromSetPcksList($pcksList))) {
            throw new \InvalidArgumentException($pcksListArrayErrorMessage, __LINE__);
        }
        $this->PcksList = $pcksList;
        return $this;
    }
    /**
     * Add item to PcksList value
     * @throws \InvalidArgumentException
     * @param \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject $item
     * @return \Scraper\ScraperColisPrive\StructType\GetPickupPointsListReturn
     */
    public function addToPcksList(\Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject) {
            throw new \InvalidArgumentException(sprintf('The PcksList property can only contain items of type \Scraper\ScraperColisPrive\StructType\PickupPointDeliveryObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PcksList[] = $item;
        return $this;
    }
}
