<?php

namespace Scraper\ScraperColisPrive\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPickupPointRequest StructType
 * @subpackage Structs
 */
class GetPickupPointRequest extends AbstractStructBase
{
    /**
     * The SecurityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Scraper\ScraperColisPrive\StructType\IdentificationObject
     */
    public $SecurityID;
    /**
     * The PckCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PckCode;
    /**
     * Constructor method for GetPickupPointRequest
     * @uses GetPickupPointRequest::setSecurityID()
     * @uses GetPickupPointRequest::setPckCode()
     * @param \Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID
     * @param string $pckCode
     */
    public function __construct(\Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID = null, $pckCode = null)
    {
        $this
            ->setSecurityID($securityID)
            ->setPckCode($pckCode);
    }
    /**
     * Get SecurityID value
     * @return \Scraper\ScraperColisPrive\StructType\IdentificationObject
     */
    public function getSecurityID()
    {
        return $this->SecurityID;
    }
    /**
     * Set SecurityID value
     * @param \Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID
     * @return \Scraper\ScraperColisPrive\StructType\GetPickupPointRequest
     */
    public function setSecurityID(\Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID = null)
    {
        $this->SecurityID = $securityID;
        return $this;
    }
    /**
     * Get PckCode value
     * @return string
     */
    public function getPckCode()
    {
        return $this->PckCode;
    }
    /**
     * Set PckCode value
     * @param string $pckCode
     * @return \Scraper\ScraperColisPrive\StructType\GetPickupPointRequest
     */
    public function setPckCode($pckCode = null)
    {
        // validation for constraint: string
        if (!is_null($pckCode) && !is_string($pckCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pckCode, true), gettype($pckCode)), __LINE__);
        }
        $this->PckCode = $pckCode;
        return $this;
    }
}
