<?php

namespace Scraper\ScraperColisPrive\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Set2ndDeliveryRequest StructType
 * @subpackage Structs
 */
class Set2ndDeliveryRequest extends AbstractStructBase
{
    /**
     * The SecurityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Scraper\ScraperColisPrive\StructType\IdentificationObject
     */
    public $SecurityID;
    /**
     * The CPPclCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CPPclCode;
    /**
     * The CsgZC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CsgZC;
    /**
     * The DlvrModeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DlvrModeType;
    /**
     * The DlvrAdd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Scraper\ScraperColisPrive\StructType\DeliveryAddressObject
     */
    public $DlvrAdd;
    /**
     * The DlvrDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DlvrDate;
    /**
     * Constructor method for Set2ndDeliveryRequest
     * @uses Set2ndDeliveryRequest::setSecurityID()
     * @uses Set2ndDeliveryRequest::setCPPclCode()
     * @uses Set2ndDeliveryRequest::setCsgZC()
     * @uses Set2ndDeliveryRequest::setDlvrModeType()
     * @uses Set2ndDeliveryRequest::setDlvrAdd()
     * @uses Set2ndDeliveryRequest::setDlvrDate()
     * @param \Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID
     * @param string $cPPclCode
     * @param string $csgZC
     * @param string $dlvrModeType
     * @param \Scraper\ScraperColisPrive\StructType\DeliveryAddressObject $dlvrAdd
     * @param string $dlvrDate
     */
    public function __construct(\Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID = null, $cPPclCode = null, $csgZC = null, $dlvrModeType = null, \Scraper\ScraperColisPrive\StructType\DeliveryAddressObject $dlvrAdd = null, $dlvrDate = null)
    {
        $this
            ->setSecurityID($securityID)
            ->setCPPclCode($cPPclCode)
            ->setCsgZC($csgZC)
            ->setDlvrModeType($dlvrModeType)
            ->setDlvrAdd($dlvrAdd)
            ->setDlvrDate($dlvrDate);
    }
    /**
     * Get SecurityID value
     * @return \Scraper\ScraperColisPrive\StructType\IdentificationObject
     */
    public function getSecurityID()
    {
        return $this->SecurityID;
    }
    /**
     * Set SecurityID value
     * @param \Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID
     * @return \Scraper\ScraperColisPrive\StructType\Set2ndDeliveryRequest
     */
    public function setSecurityID(\Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID = null)
    {
        $this->SecurityID = $securityID;
        return $this;
    }
    /**
     * Get CPPclCode value
     * @return string
     */
    public function getCPPclCode()
    {
        return $this->CPPclCode;
    }
    /**
     * Set CPPclCode value
     * @param string $cPPclCode
     * @return \Scraper\ScraperColisPrive\StructType\Set2ndDeliveryRequest
     */
    public function setCPPclCode($cPPclCode = null)
    {
        // validation for constraint: string
        if (!is_null($cPPclCode) && !is_string($cPPclCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPPclCode, true), gettype($cPPclCode)), __LINE__);
        }
        $this->CPPclCode = $cPPclCode;
        return $this;
    }
    /**
     * Get CsgZC value
     * @return string
     */
    public function getCsgZC()
    {
        return $this->CsgZC;
    }
    /**
     * Set CsgZC value
     * @param string $csgZC
     * @return \Scraper\ScraperColisPrive\StructType\Set2ndDeliveryRequest
     */
    public function setCsgZC($csgZC = null)
    {
        // validation for constraint: string
        if (!is_null($csgZC) && !is_string($csgZC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($csgZC, true), gettype($csgZC)), __LINE__);
        }
        $this->CsgZC = $csgZC;
        return $this;
    }
    /**
     * Get DlvrModeType value
     * @return string
     */
    public function getDlvrModeType()
    {
        return $this->DlvrModeType;
    }
    /**
     * Set DlvrModeType value
     * @uses \Scraper\ScraperColisPrive\EnumType\EnumDeliveryModeType::valueIsValid()
     * @uses \Scraper\ScraperColisPrive\EnumType\EnumDeliveryModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dlvrModeType
     * @return \Scraper\ScraperColisPrive\StructType\Set2ndDeliveryRequest
     */
    public function setDlvrModeType($dlvrModeType = null)
    {
        // validation for constraint: enumeration
        if (!\Scraper\ScraperColisPrive\EnumType\EnumDeliveryModeType::valueIsValid($dlvrModeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Scraper\ScraperColisPrive\EnumType\EnumDeliveryModeType', is_array($dlvrModeType) ? implode(', ', $dlvrModeType) : var_export($dlvrModeType, true), implode(', ', \Scraper\ScraperColisPrive\EnumType\EnumDeliveryModeType::getValidValues())), __LINE__);
        }
        $this->DlvrModeType = $dlvrModeType;
        return $this;
    }
    /**
     * Get DlvrAdd value
     * @return \Scraper\ScraperColisPrive\StructType\DeliveryAddressObject
     */
    public function getDlvrAdd()
    {
        return $this->DlvrAdd;
    }
    /**
     * Set DlvrAdd value
     * @param \Scraper\ScraperColisPrive\StructType\DeliveryAddressObject $dlvrAdd
     * @return \Scraper\ScraperColisPrive\StructType\Set2ndDeliveryRequest
     */
    public function setDlvrAdd(\Scraper\ScraperColisPrive\StructType\DeliveryAddressObject $dlvrAdd = null)
    {
        $this->DlvrAdd = $dlvrAdd;
        return $this;
    }
    /**
     * Get DlvrDate value
     * @return string
     */
    public function getDlvrDate()
    {
        return $this->DlvrDate;
    }
    /**
     * Set DlvrDate value
     * @param string $dlvrDate
     * @return \Scraper\ScraperColisPrive\StructType\Set2ndDeliveryRequest
     */
    public function setDlvrDate($dlvrDate = null)
    {
        // validation for constraint: string
        if (!is_null($dlvrDate) && !is_string($dlvrDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dlvrDate, true), gettype($dlvrDate)), __LINE__);
        }
        $this->DlvrDate = $dlvrDate;
        return $this;
    }
}
