<?php

namespace Scraper\ScraperColisPrive\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelParcelRequest StructType
 * @subpackage Structs
 */
class CancelParcelRequest extends AbstractStructBase
{
    /**
     * The SecurityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Scraper\ScraperColisPrive\StructType\IdentificationObject
     */
    public $SecurityID;
    /**
     * The CPPclCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CPPclCode;
    /**
     * The CsgZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CsgZipCode;
    /**
     * Constructor method for CancelParcelRequest
     * @uses CancelParcelRequest::setSecurityID()
     * @uses CancelParcelRequest::setCPPclCode()
     * @uses CancelParcelRequest::setCsgZipCode()
     * @param \Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID
     * @param string $cPPclCode
     * @param string $csgZipCode
     */
    public function __construct(\Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID = null, $cPPclCode = null, $csgZipCode = null)
    {
        $this
            ->setSecurityID($securityID)
            ->setCPPclCode($cPPclCode)
            ->setCsgZipCode($csgZipCode);
    }
    /**
     * Get SecurityID value
     * @return \Scraper\ScraperColisPrive\StructType\IdentificationObject
     */
    public function getSecurityID()
    {
        return $this->SecurityID;
    }
    /**
     * Set SecurityID value
     * @param \Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID
     * @return \Scraper\ScraperColisPrive\StructType\CancelParcelRequest
     */
    public function setSecurityID(\Scraper\ScraperColisPrive\StructType\IdentificationObject $securityID = null)
    {
        $this->SecurityID = $securityID;
        return $this;
    }
    /**
     * Get CPPclCode value
     * @return string
     */
    public function getCPPclCode()
    {
        return $this->CPPclCode;
    }
    /**
     * Set CPPclCode value
     * @param string $cPPclCode
     * @return \Scraper\ScraperColisPrive\StructType\CancelParcelRequest
     */
    public function setCPPclCode($cPPclCode = null)
    {
        // validation for constraint: string
        if (!is_null($cPPclCode) && !is_string($cPPclCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPPclCode, true), gettype($cPPclCode)), __LINE__);
        }
        $this->CPPclCode = $cPPclCode;
        return $this;
    }
    /**
     * Get CsgZipCode value
     * @return string
     */
    public function getCsgZipCode()
    {
        return $this->CsgZipCode;
    }
    /**
     * Set CsgZipCode value
     * @param string $csgZipCode
     * @return \Scraper\ScraperColisPrive\StructType\CancelParcelRequest
     */
    public function setCsgZipCode($csgZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($csgZipCode) && !is_string($csgZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($csgZipCode, true), gettype($csgZipCode)), __LINE__);
        }
        $this->CsgZipCode = $csgZipCode;
        return $this;
    }
}
