<?php

namespace GlsPoland\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cParcelReturn StructType
 * @subpackage Structs
 */
class CParcelReturn extends AbstractStructBase
{
    /**
     * The parcelNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $parcelNumber;
    /**
     * The shippingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shippingCode;
    /**
     * The expiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expiryDate;
    /**
     * The sendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $sendEmail;
    /**
     * The file
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $file;
    /**
     * Constructor method for cParcelReturn
     * @uses CParcelReturn::setParcelNumber()
     * @uses CParcelReturn::setShippingCode()
     * @uses CParcelReturn::setExpiryDate()
     * @uses CParcelReturn::setSendEmail()
     * @uses CParcelReturn::setFile()
     * @param string $parcelNumber
     * @param string $shippingCode
     * @param string $expiryDate
     * @param bool $sendEmail
     * @param string $file
     */
    public function __construct($parcelNumber = null, $shippingCode = null, $expiryDate = null, $sendEmail = null, $file = null)
    {
        $this
            ->setParcelNumber($parcelNumber)
            ->setShippingCode($shippingCode)
            ->setExpiryDate($expiryDate)
            ->setSendEmail($sendEmail)
            ->setFile($file);
    }
    /**
     * Get parcelNumber value
     * @return string
     */
    public function getParcelNumber()
    {
        return $this->parcelNumber;
    }
    /**
     * Set parcelNumber value
     * @param string $parcelNumber
     * @return \GlsPoland\StructType\CParcelReturn
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelNumber) && !is_string($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->parcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get shippingCode value
     * @return string
     */
    public function getShippingCode()
    {
        return $this->shippingCode;
    }
    /**
     * Set shippingCode value
     * @param string $shippingCode
     * @return \GlsPoland\StructType\CParcelReturn
     */
    public function setShippingCode($shippingCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCode) && !is_string($shippingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCode, true), gettype($shippingCode)), __LINE__);
        }
        $this->shippingCode = $shippingCode;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \GlsPoland\StructType\CParcelReturn
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get sendEmail value
     * @return bool
     */
    public function getSendEmail()
    {
        return $this->sendEmail;
    }
    /**
     * Set sendEmail value
     * @param bool $sendEmail
     * @return \GlsPoland\StructType\CParcelReturn
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        $this->sendEmail = $sendEmail;
        return $this;
    }
    /**
     * Get file value
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param string $file
     * @return \GlsPoland\StructType\CParcelReturn
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file, true), gettype($file)), __LINE__);
        }
        $this->file = $file;
        return $this;
    }
}
