<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dec ServiceType
 * @subpackage Services
 */
class Dec extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get consignment customs declarations from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_GetConsignCustomsDec $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_GetConsignCustomsDecResponse|bool
     */
    public function adePreparingBox_GetConsignCustomsDec(\GlsPoland\StructType\AdePreparingBox_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get customs declarations for consignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetConsignCustomsDec $parameters
     * @return \GlsPoland\StructType\AdePickup_GetConsignCustomsDecResponse|bool
     */
    public function adePickup_GetConsignCustomsDec(\GlsPoland\StructType\AdePickup_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetConsignCustomsDecResponse|\GlsPoland\StructType\AdePreparingBox_GetConsignCustomsDecResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
